/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc.user;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.util.Assert;

public class OidcUserAuthority
extends OAuth2UserAuthority {
    private final OidcIdToken idToken;
    private final OidcUserInfo userInfo;

    public OidcUserAuthority(OidcIdToken idToken) {
        this(idToken, null);
    }

    public OidcUserAuthority(OidcIdToken idToken, OidcUserInfo userInfo) {
        this("OIDC_USER", idToken, userInfo);
    }

    public OidcUserAuthority(String authority, OidcIdToken idToken, OidcUserInfo userInfo) {
        super(authority, OidcUserAuthority.collectClaims(idToken, userInfo));
        this.idToken = idToken;
        this.userInfo = userInfo;
    }

    public OidcIdToken getIdToken() {
        return this.idToken;
    }

    public OidcUserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OidcUserAuthority that = (OidcUserAuthority)obj;
        if (!this.getIdToken().equals(that.getIdToken())) {
            return false;
        }
        return this.getUserInfo() != null ? this.getUserInfo().equals(that.getUserInfo()) : that.getUserInfo() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getIdToken().hashCode();
        result = 31 * result + (this.getUserInfo() != null ? this.getUserInfo().hashCode() : 0);
        return result;
    }

    static Map<String, Object> collectClaims(OidcIdToken idToken, OidcUserInfo userInfo) {
        Assert.notNull((Object)idToken, (String)"idToken cannot be null");
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (userInfo != null) {
            claims.putAll(userInfo.getClaims());
        }
        claims.putAll(idToken.getClaims());
        return claims;
    }
}

