/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Collection;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.internal.MutationOperationGroupSingle;

public class RemoveCoordinatorTablePerSubclass
implements RemoveCoordinator {
    private final OneToManyPersister mutationTarget;
    private final OperationProducer operationProducer;
    private MutationOperationGroupSingle[] operationGroups;

    public RemoveCoordinatorTablePerSubclass(OneToManyPersister mutationTarget, OperationProducer operationProducer) {
        this.mutationTarget = mutationTarget;
        this.operationProducer = operationProducer;
    }

    public String toString() {
        return "RemoveCoordinator(" + this.mutationTarget.getRolePath() + ")";
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public String getSqlString() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllRows(Object key, SharedSessionContractImplementor session) {
        MutationOperationGroupSingle[] operationGroups;
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER_DEBUG_ENABLED) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Deleting collection - %s : %s", (Object)this.mutationTarget.getRolePath(), key);
        }
        if ((operationGroups = this.operationGroups) == null) {
            operationGroups = this.operationGroups = this.buildOperationGroups();
        }
        MutationExecutorService mutationExecutorService = session.getFactory().getFastSessionServices().getMutationExecutorService();
        ForeignKeyDescriptor fkDescriptor = this.mutationTarget.getTargetPart().getKeyDescriptor();
        for (MutationOperationGroupSingle operationGroup : operationGroups) {
            MutationExecutor mutationExecutor = mutationExecutorService.createExecutor(() -> null, operationGroup, session);
            try {
                fkDescriptor.getKeyPart().decompose(key, 0, mutationExecutor.getJdbcValueBindings(), null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
                mutationExecutor.execute(key, null, null, null, session);
            }
            finally {
                mutationExecutor.release();
            }
        }
    }

    private MutationOperationGroupSingle[] buildOperationGroups() {
        Collection<EntityMappingType> subMappingTypes = this.mutationTarget.getElementPersister().getRootEntityDescriptor().getSubMappingTypes();
        MutationOperationGroupSingle[] operationGroups = new MutationOperationGroupSingle[subMappingTypes.size()];
        int i = 0;
        for (EntityMappingType subMappingType : subMappingTypes) {
            operationGroups[i++] = this.buildOperationGroup(subMappingType.getEntityPersister());
        }
        return operationGroups;
    }

    private MutationOperationGroupSingle buildOperationGroup(EntityPersister elementPersister) {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER_TRACE_ENABLED) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Starting RemoveCoordinator#buildOperationGroup - %s", (Object)this.mutationTarget.getRolePath());
        }
        CollectionTableMapping collectionTableMapping = this.mutationTarget.getCollectionTableMapping();
        MutatingTableReference tableReference = new MutatingTableReference(new CollectionTableMapping(elementPersister.getMappedTableDetails().getTableName(), collectionTableMapping.getSpaces(), collectionTableMapping.isJoinTable(), collectionTableMapping.isInverse(), collectionTableMapping.getInsertDetails(), collectionTableMapping.getUpdateDetails(), collectionTableMapping.isCascadeDeleteEnabled(), collectionTableMapping.getDeleteDetails(), collectionTableMapping.getDeleteRowDetails()));
        return new MutationOperationGroupSingle(MutationType.DELETE, this.mutationTarget, this.operationProducer.createOperation(tableReference));
    }
}

