/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.java.decompiler.code.CodeConstants;
import org.jetbrains.java.decompiler.code.ConstantsUtil;
import org.jetbrains.java.decompiler.code.InstructionSequence;

public class Instruction
implements CodeConstants {
    public int opcode;
    public int group = 1;
    public boolean wide = false;
    public int bytecode_version = 1;
    private int[] operands = null;

    public int length() {
        return 1;
    }

    public int operandsCount() {
        return this.operands == null ? 0 : this.operands.length;
    }

    public int getOperand(int index) {
        return this.operands[index];
    }

    public Instruction clone() {
        return ConstantsUtil.getInstructionInstance(this.opcode, this.wide, this.group, this.bytecode_version, this.operands == null ? null : (int[])this.operands.clone());
    }

    public String toString() {
        String res = this.wide ? "@wide " : "";
        res = res + "@" + ConstantsUtil.getName(this.opcode);
        int len = this.operandsCount();
        for (int i = 0; i < len; ++i) {
            int op = this.operands[i];
            res = op < 0 ? res + " -" + Integer.toHexString(-op) : res + " " + Integer.toHexString(op);
        }
        return res;
    }

    public boolean canFallthrough() {
        return this.opcode != 167 && this.opcode != 200 && this.opcode != 169 && (this.opcode < 172 || this.opcode > 177) && this.opcode != 191 && this.opcode != 168 && this.opcode != 170 && this.opcode != 171;
    }

    public boolean equalsInstruction(Instruction instr) {
        if (this.opcode != instr.opcode || this.wide != instr.wide || this.operandsCount() != instr.operandsCount()) {
            return false;
        }
        if (this.operands != null) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i] == instr.getOperand(i)) continue;
                return false;
            }
        }
        return true;
    }

    public void initInstruction(InstructionSequence seq) {
    }

    public void writeToStream(DataOutputStream out, int offset) throws IOException {
        out.writeByte(this.opcode);
    }

    public int[] getOperands() {
        return this.operands;
    }

    public void setOperands(int[] operands) {
        this.operands = operands;
    }
}

