/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.TagReaderImpl;

public final class ProtobufParser {
    public static final ProtobufParser INSTANCE = new ProtobufParser();

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, InputStream input) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        TagReaderImpl in = TagReaderImpl.newInstance(null, input);
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, byte[] buf, int off, int len) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        TagReaderImpl in = TagReaderImpl.newInstance(null, buf, off, len);
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, byte[] buf) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        TagReaderImpl in = TagReaderImpl.newInstance(null, buf);
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    public void parse(TagHandler tagHandler, Descriptor messageDescriptor, TagReader in) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        this.parseInternal(tagHandler, messageDescriptor, in);
    }

    private void parseInternal(TagHandler tagHandler, Descriptor messageDescriptor, TagReader in) throws IOException {
        tagHandler.onStart(messageDescriptor);
        this.parseMessage(tagHandler, messageDescriptor, in);
        tagHandler.onEnd();
    }

    private void parseMessage(TagHandler tagHandler, Descriptor messageDescriptor, TagReader in) throws IOException {
        int tag;
        block21: while ((tag = in.readTag()) != 0) {
            int fieldNumber = WireType.getTagFieldNumber(tag);
            WireType wireType = WireType.fromTag(tag);
            FieldDescriptor fd = messageDescriptor != null ? messageDescriptor.findFieldByNumber(fieldNumber) : null;
            switch (wireType) {
                case LENGTH_DELIMITED: {
                    if (fd == null) {
                        byte[] value = in.readByteArray();
                        tagHandler.onTag(fieldNumber, null, value);
                        continue block21;
                    }
                    if (fd.getType() == Type.STRING) {
                        String value = in.readString();
                        tagHandler.onTag(fieldNumber, fd, value);
                        continue block21;
                    }
                    if (fd.getType() == Type.BYTES) {
                        byte[] value = in.readByteArray();
                        tagHandler.onTag(fieldNumber, fd, value);
                        continue block21;
                    }
                    if (fd.getType() != Type.MESSAGE) continue block21;
                    int length = in.readUInt32();
                    int oldLimit = in.pushLimit(length);
                    tagHandler.onStartNested(fieldNumber, fd);
                    this.parseMessage(tagHandler, fd.getMessageType(), in);
                    tagHandler.onEndNested(fieldNumber, fd);
                    in.checkLastTagWas(0);
                    in.popLimit(oldLimit);
                    continue block21;
                }
                case START_GROUP: {
                    if (fd != null) {
                        tagHandler.onStartNested(fieldNumber, null);
                        this.parseMessage(tagHandler, null, in);
                        in.checkLastTagWas(WireType.makeTag(fieldNumber, 4));
                        tagHandler.onEndNested(fieldNumber, null);
                        continue block21;
                    }
                    tagHandler.onStartNested(fieldNumber, fd);
                    this.parseMessage(tagHandler, fd.getMessageType(), in);
                    in.checkLastTagWas(WireType.makeTag(fieldNumber, 4));
                    tagHandler.onEndNested(fieldNumber, fd);
                    continue block21;
                }
                case FIXED32: 
                case FIXED64: 
                case VARINT: {
                    if (fd == null) {
                        if (wireType == WireType.FIXED32) {
                            tagHandler.onTag(fieldNumber, null, in.readFixed32());
                            continue block21;
                        }
                        if (wireType == WireType.FIXED64) {
                            tagHandler.onTag(fieldNumber, null, in.readFixed64());
                            continue block21;
                        }
                        tagHandler.onTag(fieldNumber, null, in.readUInt64());
                        continue block21;
                    }
                    Constable value = switch (fd.getType()) {
                        case Type.DOUBLE -> in.readDouble();
                        case Type.FLOAT -> Float.valueOf(in.readFloat());
                        case Type.BOOL -> Boolean.valueOf(in.readBool());
                        case Type.INT32 -> in.readInt32();
                        case Type.SFIXED32 -> in.readSFixed32();
                        case Type.FIXED32 -> in.readFixed32();
                        case Type.UINT32 -> in.readUInt32();
                        case Type.SINT32 -> in.readSInt32();
                        case Type.INT64 -> in.readInt64();
                        case Type.UINT64 -> in.readUInt64();
                        case Type.FIXED64 -> in.readFixed64();
                        case Type.SFIXED64 -> in.readSFixed64();
                        case Type.SINT64 -> in.readSInt64();
                        case Type.ENUM -> in.readEnum();
                        default -> throw new IOException("Unexpected field type " + fd.getType() + " for field " + fieldNumber);
                    };
                    tagHandler.onTag(fieldNumber, fd, value);
                    continue block21;
                }
            }
            throw new IOException("Found tag with invalid wire type : tag=" + tag + ", wireType=" + wireType);
        }
    }
}

