/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.proxy;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.proxy.ProxySocketFactory;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.net.SocketFactory;

@Protocol(name="proxy")
public class ProxyConnection
extends BaseOverthereConnection
implements AddressPortMapper,
OverthereConnectionBuilder {
    public static final String PROXY_PROTOCOL = "proxy";
    public static final String PROXY_TYPE = "proxyType";
    public static final Proxy.Type PROXY_TYPE_DEFAULT = Proxy.Type.HTTP;
    private final String proxyAddress;
    private final int proxyPort;
    private final Proxy.Type proxyType;

    public ProxyConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, ProxyConnection.augmentOptions(options), mapper, false);
        String unmappedAddress = (String)options.get("address");
        int unmappedPort = options.getInteger("port");
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(unmappedAddress, unmappedPort));
        this.proxyAddress = addressPort.getHostName();
        this.proxyPort = addressPort.getPort();
        this.proxyType = options.getEnum(PROXY_TYPE, Proxy.Type.class, PROXY_TYPE_DEFAULT);
        if (this.proxyType != Proxy.Type.HTTP) {
            throw new IllegalArgumentException("Proxy of type other than HTTP not supported");
        }
        if (options.containsKey("jumpstation")) {
            throw new IllegalArgumentException("Cannot configure an HTTP proxy behind another proxy or behind an SSH jumpstation");
        }
    }

    private static ConnectionOptions augmentOptions(ConnectionOptions options) {
        if (options.containsKey("os")) {
            return options;
        }
        ConnectionOptions augmentedOptions = new ConnectionOptions(options);
        augmentedOptions.set("os", (Object)OperatingSystemFamily.UNIX);
        return augmentedOptions;
    }

    @Override
    public OverthereConnection connect() {
        return this;
    }

    @Override
    public InetSocketAddress map(InetSocketAddress address) {
        return this.mapper.map(address);
    }

    @Override
    public SocketFactory socketFactory() {
        Proxy p = new Proxy(this.proxyType, new InetSocketAddress(this.proxyAddress, this.proxyPort));
        return new ProxySocketFactory(p);
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        throw new UnsupportedOperationException("Cannot get a file from the proxy.");
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        throw new UnsupportedOperationException("Cannot get a file from the proxy.");
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) {
        throw new UnsupportedOperationException("Cannot get a file from the proxy.");
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot start a process on the proxy.");
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        throw new UnsupportedOperationException("Cannot set a working directory on the proxy.");
    }

    @Override
    public OverthereFile getWorkingDirectory() {
        throw new UnsupportedOperationException("Cannot get a working directory from the proxy.");
    }

    @Override
    public int execute(OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot execute a command on the proxy.");
    }

    @Override
    public String toString() {
        return "proxy:" + this.proxyType.toString().toLowerCase() + "://" + this.proxyAddress + ":" + this.proxyPort;
    }
}

