/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport INSTANCE = new PostgreSQLAggregateSupport();

    public static AggregateSupport valueOf(Dialect dialect) {
        return INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String column, ColumnTypeInformation aggregateColumnType, ColumnTypeInformation columnType) {
        switch (aggregateColumnType.getTypeCode()) {
            case 3001: {
                switch (columnType.getTypeCode()) {
                    case 3001: {
                        return template.replace(placeholder, aggregateParentReadExpression + "->'" + column + "'");
                    }
                    case -3: 
                    case -2: 
                    case 4003: {
                        return template.replace(placeholder, "decode(" + aggregateParentReadExpression + "->>'" + column + "','hex')");
                    }
                }
                return template.replace(placeholder, "cast(" + aggregateParentReadExpression + "->>'" + column + "' as " + columnType.getTypeName() + ")");
            }
            case 2002: {
                return template.replace(placeholder, "(" + aggregateParentReadExpression + ")." + column);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnType.getTypeCode());
    }

    private static String jsonCustomWriteExpression(String customWriteExpression, int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 4003: {
                return "to_jsonb(encode(" + customWriteExpression + ",'hex'))";
            }
        }
        return "to_jsonb(" + customWriteExpression + ")";
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String column, ColumnTypeInformation aggregateColumnType, ColumnTypeInformation columnType) {
        switch (aggregateColumnType.getTypeCode()) {
            case 3001: {
                return aggregateParentAssignmentExpression;
            }
            case 2002: {
                return aggregateParentAssignmentExpression + "." + column;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnType.getTypeCode());
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean preferSelectAggregateMapping(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode != 2002;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return this.jsonAggregateColumnWriter(aggregateColumn, columnsToUpdate);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private AggregateSupport.WriteExpressionRenderer jsonAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
        return new RootJsonWriteExpression(aggregateColumn, columns);
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = customWriteExpression.split("\\?");
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("',");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final boolean nullable;
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            this.nullable = aggregateColumn.isNullable();
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            if (this.nullable) {
                sqlAppender.append("coalesce(");
                sqlAppender.append((CharSequence)basePath);
                sqlAppender.append(",'{}')");
            } else {
                sqlAppender.append((CharSequence)basePath);
            }
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression() {
        }

        protected void initializeSubExpressions(SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression());
                }
                int sqlTypeCode = column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, PostgreSQLAggregateSupport.jsonCustomWriteExpression(customWriteExpression, sqlTypeCode)));
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("||jsonb_build_object");
            int separator = 40;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = path + "->'" + column + "'";
                sb.append((char)separator);
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append('\'');
                    sb.append(column);
                    sb.append("',coalesce(");
                    sb.append(subPath);
                    sb.append(",'{}')");
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                separator = 44;
            }
            sb.append(')');
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

