/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate5;

import jakarta.persistence.PersistenceException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.PropertyValueException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.service.UnknownServiceException;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.lang.Nullable;
import org.springframework.orm.hibernate5.HibernateJdbcException;
import org.springframework.orm.hibernate5.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate5.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate5.HibernateQueryException;
import org.springframework.orm.hibernate5.HibernateSystemException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class SessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    static final Log logger = LogFactory.getLog(SessionFactoryUtils.class);

    static void flush(Session session, boolean synch) throws DataAccessException {
        if (synch) {
            logger.debug((Object)"Flushing Hibernate Session on transaction synchronization");
        } else {
            logger.debug((Object)"Flushing Hibernate Session on explicit request");
        }
        try {
            session.flush();
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
        catch (PersistenceException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof HibernateException) {
                HibernateException hibernateException = (HibernateException)throwable;
                throw SessionFactoryUtils.convertHibernateAccessException(hibernateException);
            }
            throw ex;
        }
    }

    public static void closeSession(@Nullable Session session) {
        if (session != null) {
            try {
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (Throwable ex) {
                logger.error((Object)"Failed to release Hibernate Session", ex);
            }
        }
    }

    @Nullable
    public static DataSource getDataSource(SessionFactory sessionFactory) {
        block5: {
            Object dataSourceValue;
            Map props;
            Method getProperties = ClassUtils.getMethodIfAvailable(sessionFactory.getClass(), (String)"getProperties", (Class[])new Class[0]);
            if (getProperties != null && (props = (Map)ReflectionUtils.invokeMethod((Method)getProperties, (Object)sessionFactory)) != null && (dataSourceValue = props.get("hibernate.connection.datasource")) instanceof DataSource) {
                DataSource dataSource = (DataSource)dataSourceValue;
                return dataSource;
            }
            if (sessionFactory instanceof SessionFactoryImplementor) {
                SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
                try {
                    ConnectionProvider cp = (ConnectionProvider)sfi.getServiceRegistry().getService(ConnectionProvider.class);
                    if (cp != null) {
                        return (DataSource)cp.unwrap(DataSource.class);
                    }
                }
                catch (UnknownServiceException ex) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)("No ConnectionProvider found - cannot determine DataSource for SessionFactory: " + ex));
                }
            }
        }
        return null;
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SQLGrammarException) {
            SQLGrammarException hibJdbcEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + hibJdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof org.hibernate.QueryTimeoutException) {
            org.hibernate.QueryTimeoutException hibJdbcEx = (org.hibernate.QueryTimeoutException)ex;
            return new QueryTimeoutException(ex.getMessage() + "; SQL [" + hibJdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException hibJdbcEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + hibJdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof PessimisticLockException) {
            PessimisticLockException hibJdbcEx = (PessimisticLockException)ex;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + hibJdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException hibJdbcEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + hibJdbcEx.getSQL() + "]; constraint [" + hibJdbcEx.getConstraintName() + "]", (Throwable)ex);
        }
        if (ex instanceof DataException) {
            DataException hibJdbcEx = (DataException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + hibJdbcEx.getSQL() + "]", (Throwable)ex);
        }
        if (ex instanceof JDBCException) {
            JDBCException hibJdbcEx = (JDBCException)ex;
            return new HibernateJdbcException(hibJdbcEx);
        }
        if (ex instanceof QueryException) {
            QueryException queryException = (QueryException)ex;
            return new HibernateQueryException(queryException);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            UnresolvableObjectException unresolvableObjectException = (UnresolvableObjectException)ex;
            return new HibernateObjectRetrievalFailureException(unresolvableObjectException);
        }
        if (ex instanceof WrongClassException) {
            WrongClassException wrongClassException = (WrongClassException)ex;
            return new HibernateObjectRetrievalFailureException(wrongClassException);
        }
        if (ex instanceof StaleObjectStateException) {
            StaleObjectStateException staleObjectStateException = (StaleObjectStateException)ex;
            return new HibernateOptimisticLockingFailureException(staleObjectStateException);
        }
        if (ex instanceof StaleStateException) {
            StaleStateException staleStateException = (StaleStateException)ex;
            return new HibernateOptimisticLockingFailureException(staleStateException);
        }
        if (ex instanceof OptimisticEntityLockException) {
            OptimisticEntityLockException optimisticEntityLockException = (OptimisticEntityLockException)ex;
            return new HibernateOptimisticLockingFailureException(optimisticEntityLockException);
        }
        if (ex instanceof PessimisticEntityLockException) {
            if (ex.getCause() instanceof LockAcquisitionException) {
                return new CannotAcquireLockException(ex.getMessage(), ex.getCause());
            }
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        return new HibernateSystemException(ex);
    }
}

