/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import com.sun.jna.Callback;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.PlatformEx;
import com.sun.jna.Pointer;
import com.sun.jna.StringBlock;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jnacontrib.jna.Advapi32;
import jnacontrib.jna.Options;
import org.apache.commons.collections.map.MultiValueMap;
import org.rzo.yajsw.io.CyclicBufferFileInputStream;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.os.AbstractProcess;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.ms.win.w32.Pdh;
import org.rzo.yajsw.os.ms.win.w32.PdhCounter;

public class WindowsXPProcess
extends AbstractProcess {
    volatile MyKernel32.STARTUPINFO _startupInfo;
    volatile MyKernel32.PROCESS_INFORMATION _processInformation;
    volatile PointerByReference inRead = null;
    volatile PointerByReference inWrite = null;
    volatile PointerByReference outRead = null;
    volatile PointerByReference outWrite = null;
    volatile PointerByReference errRead = null;
    volatile PointerByReference errWrite = null;
    volatile MyKernel32.SECURITY_ATTRIBUTES sa;
    volatile Pointer m_hOutPipe = null;
    volatile Pointer m_hErrPipe = null;
    volatile Pointer m_hInPipe = null;
    volatile Pointer inWritePipe = null;
    volatile Pointer outReadPipe = null;
    volatile Pointer errReadPipe = null;
    volatile int _isElevated = -1;
    int levels;
    private PdhCounter _pfCounter;
    private PdhCounter _vMemCounter;
    private PdhCounter _cpuCounter;
    private PdhCounter _pMemCounter;
    private PdhCounter _threadCounter;
    private PdhCounter _handleCounter;
    private boolean _started = false;
    volatile boolean destroyed = false;
    WinDef.HWND lastActiveWindow = null;

    public static Process getProcess(int pid) {
        WindowsXPProcess result = new WindowsXPProcess();
        WinNT.HANDLE hProcess = MyKernel32.INSTANCE.OpenProcess(0x1F0FFF, false, pid);
        if (hProcess == null) {
            hProcess = MyKernel32.INSTANCE.OpenProcess(1024, false, pid);
        }
        if (hProcess == null) {
            return null;
        }
        result._pid = pid;
        result._processInformation = new MyKernel32.PROCESS_INFORMATION();
        result._processInformation.dwProcessId = pid;
        result._processInformation.hProcess = hProcess;
        result._cmd = result.getCommandLineInternal();
        if (result._cmd.equals("?")) {
            result._cmd = result.getCommandLineInternalWMI();
        }
        if ("?".equals(result._cmd)) {
            System.err.println("Could not get commandline");
        }
        PointerByReference hToken = new PointerByReference();
        WinNT.HANDLE hp = new WinNT.HANDLE();
        hp.setPointer(hProcess.getPointer());
        if (MyAdvapi.INSTANCE.OpenProcessToken(hp, 131080, hToken)) {
            IntByReference dwSize = new IntByReference();
            MyAdvapi.INSTANCE.GetTokenInformation(hToken.getValue(), 1, null, 0, dwSize);
            Memory pTokenUser = new Memory((long)dwSize.getValue());
            if (MyAdvapi.INSTANCE.GetTokenInformation(hToken.getValue(), 1, pTokenUser, dwSize.getValue(), dwSize)) {
                MyAdvapi.TOKEN_USER tokenUser = new MyAdvapi.TOKEN_USER((Pointer)pTokenUser);
                Pointer lpSid = tokenUser.User.Sid;
                Memory lpName = new Memory(256L);
                IntByReference cchName = new IntByReference();
                cchName.setValue(256);
                Memory lpReferencedDomainName = new Memory(256L);
                IntByReference cchReferencedDomainName = new IntByReference();
                cchReferencedDomainName.setValue(256);
                IntByReference peUse = new IntByReference();
                if (MyAdvapi.INSTANCE.LookupAccountSidW(null, lpSid, lpName, cchName, lpReferencedDomainName, cchReferencedDomainName, peUse)) {
                    result._user = lpReferencedDomainName.getWideString(0L) + "\\" + lpName.getWideString(0L);
                }
            }
            if (result._user == null) {
                System.out.println("could not get user name OS error #" + MyKernel32.INSTANCE.GetLastError());
            }
            MyKernel32.INSTANCE.CloseHandle(hToken.getValue());
        }
        return result;
    }

    private boolean setPrivilege(Pointer hToken, String lpszPrivilege, boolean bEnablePrivilege) {
        MyAdvapi.TOKEN_PRIVILEGES tp = new MyAdvapi.TOKEN_PRIVILEGES();
        MyAdvapi.LUID luid = new MyAdvapi.LUID();
        luid.size();
        if (!MyAdvapi.INSTANCE.LookupPrivilegeValueA(null, lpszPrivilege, luid)) {
            return false;
        }
        tp.Privileges[0].Luid = luid;
        tp.write();
        tp.Privileges[0].Attributes = bEnablePrivilege ? 2 : 0;
        int size = tp.size();
        boolean result = MyAdvapi.INSTANCE.AdjustTokenPrivileges(hToken, false, tp, 0, null, null);
        if (!result) {
            int errNr = MyKernel32.INSTANCE.GetLastError();
            this.log("error setting privliges OS error #" + errNr + "/" + Integer.toHexString(errNr));
        }
        return result;
    }

    @Override
    public boolean start() {
        boolean result = false;
        if (this.isRunning()) {
            this.log("process already running -> abort start");
            return false;
        }
        this.setPid(-1);
        this.setExitCode(-1);
        this._started = false;
        int PIPE_SIZE = 1024;
        int PIPE_TIMEOUT = 12000;
        if (this._arrCmd == null && this._cmd == null) {
            return false;
        }
        if (this._cmd == null) {
            this._cmd = "";
            for (String cmd : this._arrCmd) {
                if (cmd == null || cmd.length() == 0) continue;
                this._cmd = cmd.contains(" ") && !cmd.endsWith("\"") ? this._cmd + '\"' + cmd + "\" " : this._cmd + cmd + " ";
            }
        }
        if (this._debug) {
            this.log("exec: " + this._cmd);
        }
        if (this._processInformation != null) {
            this.log("process not correctly disposed -> abort start");
            return false;
        }
        try {
            long affinity;
            this.destroyed = false;
            this._startupInfo = new MyKernel32.STARTUPINFO();
            this._startupInfo.clear();
            this._processInformation = new MyKernel32.PROCESS_INFORMATION();
            this._processInformation.clear();
            if (this._pipeStreams) {
                if (this.sa == null) {
                    this.sa = new MyKernel32.SECURITY_ATTRIBUTES();
                    this.sa.clear();
                    this.sa.nLength = this.sa.size();
                    this.sa.lpSecurityDescriptor = null;
                    this.sa.bInheritHandle = true;
                }
                this.inRead = new PointerByReference();
                this.inWrite = new PointerByReference();
                this.outRead = new PointerByReference();
                this.outWrite = new PointerByReference();
                this.errRead = new PointerByReference();
                this.errWrite = new PointerByReference();
                this._startupInfo.dwFlags = 256;
                if (MyKernel32.INSTANCE.CreatePipe(this.inRead, this.inWrite, this.sa, 0) == 0) {
                    this.log("Error in CreatePipe inWrite " + Integer.toHexString(MyKernel32.INSTANCE.GetLastError()));
                    return false;
                }
                if (!MyKernel32.INSTANCE.SetHandleInformation(this.inWrite.getValue(), 1, 0)) {
                    this.log("error in set handle inWrite -> abort start");
                    return false;
                }
                this._startupInfo.hStdInput = this.inRead.getValue();
                if (MyKernel32.INSTANCE.CreatePipe(this.outRead, this.outWrite, this.sa, 0) == 0) {
                    this.log("Error in CreatePipe outWrite " + Integer.toHexString(MyKernel32.INSTANCE.GetLastError()));
                    return false;
                }
                if (!MyKernel32.INSTANCE.SetHandleInformation(this.outRead.getValue(), 1, 0)) {
                    this.log("error in set handle outRead -> abort start");
                    return false;
                }
                this._startupInfo.hStdOutput = this.outWrite.getValue();
                if (MyKernel32.INSTANCE.CreatePipe(this.errRead, this.errWrite, this.sa, 0) == 0) {
                    this.log("Error in CreatePipe errWrite " + Integer.toHexString(MyKernel32.INSTANCE.GetLastError()));
                    return false;
                }
                if (!MyKernel32.INSTANCE.SetHandleInformation(this.errRead.getValue(), 1, 0)) {
                    this.log("error in set handle inWrite -> abort start");
                    return false;
                }
                this._startupInfo.hStdError = this.errWrite.getValue();
                if (this._redirectErrorStream) {
                    MyKernel32.INSTANCE.SetHandleInformation(this.errRead.getValue(), 1, 0);
                }
            }
            int creationFlag = 0;
            if (!this._visible) {
                creationFlag |= 0x8000400;
                this._startupInfo.lpTitle = null;
            } else {
                creationFlag |= 0x410;
                this._startupInfo.lpTitle = new WString(this._title);
                if (this._minimized) {
                    this._startupInfo.wShowWindow = (short)(this._startupInfo.wShowWindow | 6);
                    this._startupInfo.dwFlags |= 1;
                }
            }
            creationFlag |= WindowsXPProcess.getPriorityFlag(this._priority);
            this._startupInfo.write();
            WString cmd = new WString(this._cmd);
            WString wDir = this.getWorkingDir() == null ? null : new WString(this.getWorkingDir());
            String stdUser = this.standardizeUser(this._user);
            StringBlock environment = null;
            WString[] env = null;
            if (this._environment.size() != 0) {
                env = new WString[this._environment.size()];
                int i = 0;
                for (String[] entry : this._environment) {
                    env[i++] = new WString(entry[0] + "=" + entry[1]);
                }
                environment = new StringBlock(env);
            }
            if (this._desktop != null) {
                this._startupInfo.lpDesktop = new WString(this._desktop);
                this.log("setting desktop " + this._desktop);
            }
            if (this._logonActiveSession) {
                this.log("start process in active session");
                int session = -1;
                while (session == -1) {
                    session = MyKernel32.INSTANCE.WTSGetActiveConsoleSessionId();
                    if (session == -1) {
                        Thread.sleep(1000L);
                    }
                    this.log("active session: " + session);
                }
                PointerByReference phToken = new PointerByReference();
                boolean userLoggedOn = false;
                int retries = 0;
                while (!userLoggedOn) {
                    result = MyWtsapi32.INSTANCE.WTSQueryUserToken(session, phToken);
                    userLoggedOn = result || MyKernel32.INSTANCE.GetLastError() != 1008;
                    if (userLoggedOn) continue;
                    Thread.sleep(1000L);
                    ++retries;
                }
                if (retries > 0) {
                    Thread.sleep(10000L);
                }
                if (!this.doesUserHavePrivilege("SeTcbPrivilege")) {
                    this.log("WARNING: Process does not have the SE_TCB_NAME privilege !!");
                }
                if (result) {
                    this.log("got session token: " + phToken.getValue());
                    PointerByReference phNewToken = new PointerByReference();
                    result = MyAdvapi.INSTANCE.DuplicateTokenEx(phToken.getValue(), 0x2000000, null, 0, 1, phNewToken);
                    if (result) {
                        this.log("duplicated token: " + phNewToken.getValue());
                        creationFlag = 0;
                        creationFlag |= 0x8000400;
                        result = MyAdvapi.INSTANCE.CreateProcessAsUserW(phNewToken.getValue(), null, cmd, null, null, this._pipeStreams, creationFlag |= WindowsXPProcess.getPriorityFlag(this._priority), environment, new WString(this.getWorkingDir()), this._startupInfo, this._processInformation);
                        this.log("started " + result);
                    }
                }
            } else if (stdUser == null || stdUser.equals(this.currentUser())) {
                result = MyKernel32.INSTANCE.CreateProcessW(null, cmd, null, null, this._pipeStreams, creationFlag, environment, wDir, this._startupInfo, this._processInformation);
            } else {
                WString user = null;
                WString domain = null;
                int i = this._user.lastIndexOf("\\");
                if (i > 0) {
                    user = new WString(this._user.substring(this._user.lastIndexOf("\\") + 1));
                    domain = new WString(this._user.substring(0, this._user.lastIndexOf("\\")));
                } else {
                    user = new WString(this._user);
                }
                WString password = null;
                if (this._password != null) {
                    password = new WString(this._password);
                }
                this.log("current user :: requested user: " + this.currentUserName() + " :: " + stdUser);
                if (!"SYSTEM".equals(this.currentUserName()) && !this.currentUserName().endsWith("$")) {
                    PointerByReference phToken = new PointerByReference();
                    String stUser = user.toString();
                    String stDomain = domain == null ? null : domain.toString();
                    String stPassword = password == null ? "" : password.toString();
                    result = true;
                    if (result && result) {
                        if (result) {
                            // empty if block
                        }
                        if (!this.doesUserHavePrivilege("SeAssignPrimaryTokenPrivilege")) {
                            this.log("Process does not have the SE_ASSIGNPRIMARYTOKEN_NAME privilege !!");
                        }
                        if (!this.doesUserHavePrivilege("SeIncreaseQuotaPrivilege")) {
                            this.log("Process does not have the SE_INCREASE_QUOTA_NAME privilege !!");
                        }
                        if (result = MyAdvapi.INSTANCE.LogonUserA(stUser, stDomain, stPassword, 2, 0, phToken)) {
                            result = MyAdvapi.INSTANCE.CreateProcessAsUserW(phToken.getValue(), null, cmd, null, null, true, creationFlag, null, null, this._startupInfo, this._processInformation);
                        }
                    }
                } else {
                    PointerByReference phToken = new PointerByReference();
                    String stUser = user.toString();
                    String stDomain = domain == null ? null : domain.toString();
                    String stPassword = password == null ? "" : password.toString();
                    result = MyAdvapi.INSTANCE.LogonUserW(user, domain, password, 2, 0, phToken);
                    this.log("logonUserA " + result);
                    if (result && result) {
                        result = MyAdvapi.INSTANCE.CreateProcessAsUserW(phToken.getValue(), null, cmd, null, null, this._pipeStreams, creationFlag, environment, new WString(this.getWorkingDir()), this._startupInfo, this._processInformation);
                    }
                }
            }
            if (!result) {
                int err = MyKernel32.INSTANCE.GetLastError();
                this.log("could not start process " + Integer.toHexString(err));
                this.log(Kernel32Util.formatMessageFromLastErrorCode((int)err));
                this.log(this._startupInfo.toString());
                return result;
            }
            this._started = true;
            this._pid = this._processInformation.dwProcessId;
            int res = MyUser32.INSTANCE.WaitForInputIdle(this._processInformation.hProcess, 2000);
            if (res > 0) {
                this.log("Warning: WaitForInputIdle returned " + res);
            }
            if ((affinity = this.getProcessAffinity()) > 0L) {
                if (!MyKernel32.INSTANCE.SetProcessAffinityMask(this._processInformation.hProcess, affinity)) {
                    this.log("could not set process affinity");
                } else if (this._debug) {
                    this.log("Affinity set to: " + Long.toBinaryString(affinity));
                }
            }
            if (this._pipeStreams) {
                this.writefd(this.in_fd, this.inWrite.getValue());
                this.writefd(this.out_fd, this.outRead.getValue());
                this.writefd(this.err_fd, this.errRead.getValue());
                this._outputStream = new BufferedOutputStream(new FileOutputStream(this.in_fd));
                this._inputStream = new BufferedInputStream(new FileInputStream(this.out_fd));
                this._errorStream = new BufferedInputStream(new FileInputStream(this.err_fd));
                MyKernel32.INSTANCE.CloseHandle(this.inRead.getValue());
                MyKernel32.INSTANCE.CloseHandle(this.outWrite.getValue());
                MyKernel32.INSTANCE.CloseHandle(this.errWrite.getValue());
            } else if (this._teeName != null && this._tmpPath != null) {
                File f = new File(this._tmpPath);
                if (!f.exists()) {
                    f.mkdir();
                }
                this._outputStream = new CyclicBufferFilePrintStream(new File(this._tmpPath, "in_" + this._teeName));
                this._inputStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "out_" + this._teeName));
                this._errorStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "err_" + this._teeName));
                new File(this._tmpPath, "in_" + this._teeName).deleteOnExit();
                new File(this._tmpPath, "out_" + this._teeName).deleteOnExit();
                new File(this._tmpPath, "err_" + this._teeName).deleteOnExit();
            }
        }
        catch (Exception ex) {
            this.log("exception in process start: " + ex, ex);
        }
        return result;
    }

    private long getProcessAffinity() {
        if (this._cpuAffinity <= 0L) {
            return 0L;
        }
        LongByReference lpProcessAffinityMask = new LongByReference();
        LongByReference lpSystemAffinityMask = new LongByReference();
        if (MyKernel32.INSTANCE.GetProcessAffinityMask(this._processInformation.hProcess, lpProcessAffinityMask, lpSystemAffinityMask)) {
            return lpSystemAffinityMask.getValue() & this._cpuAffinity;
        }
        this.log("could not get process affinity mask -> not setting");
        return 0L;
    }

    private static int getPriorityFlag(int priority) {
        switch (priority) {
            case 0: {
                return 32;
            }
            case 1: {
                return 32768;
            }
            case 2: {
                return 128;
            }
            case -1: {
                return 16384;
            }
            case -2: {
                return 64;
            }
        }
        return 0;
    }

    @Override
    public void waitFor() {
        if (!this.isRunning()) {
            return;
        }
        this.waitFor(-1L);
    }

    private int getExitCodeInternal() {
        IntByReference code = new IntByReference();
        if (this._processInformation == null) {
            return -1;
        }
        boolean result = MyKernel32.INSTANCE.GetExitCodeProcess(this._processInformation.hProcess, code);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (result) {
            if (this._debug) {
                this.log("GetExitCodeProcess returned " + code.getValue());
            }
            return code.getValue();
        }
        this.log("Error in GetExitCodeProcess OS Error #" + MyKernel32.INSTANCE.GetLastError());
        return -3;
    }

    @Override
    public void waitFor(long timeout) {
        if (this._debug) {
            this.log("waitFor " + timeout);
        }
        try {
            if (!this.isRunning()) {
                return;
            }
            if (this._debug) {
                this.log("1waitFor ");
            }
            if (timeout > Integer.MAX_VALUE) {
                timeout = Integer.MAX_VALUE;
            }
            if (this._processInformation == null) {
                return;
            }
            long start = System.currentTimeMillis();
            if (this._debug) {
                this.log("2waitFor ");
            }
            while (this._processInformation != null && (timeout == -1L || start + timeout > System.currentTimeMillis()) && this.isRunning()) {
                if (this._debug) {
                    this.log("WaitForSingleObject +");
                }
                int result = MyKernel32.INSTANCE.WaitForSingleObject(this._processInformation.hProcess, (int)timeout);
                if (this._debug) {
                    this.log("WaitForSingleObject -");
                }
                if (this._debug) {
                    this.log("WaitForSingleObject terminated PID: " + this.getPid());
                }
                if (result == -1) {
                    int errNr = MyKernel32.INSTANCE.GetLastError();
                    this.log("Error in Process.waitFor OS Error #" + errNr + " " + Kernel32Util.formatMessageFromLastErrorCode((int)errNr));
                    continue;
                }
                if (result == 0) continue;
                this.log("Error in Process.waitFor OS result #" + result + " " + Kernel32Util.formatMessageFromLastErrorCode((int)result));
            }
        }
        catch (Throwable ex) {
            this.log("Exception in Process.waitFor: " + ex);
        }
    }

    @Override
    public boolean stop(int timeout, int code) {
        if (this._pid <= 0) {
            this.log("cannot kill process with negative pid " + this._pid);
            return false;
        }
        final AtomicBoolean messagePosted = new AtomicBoolean(false);
        MyUser32.WNDENUMPROC closeWindow = new MyUser32.WNDENUMPROC(){

            @Override
            public boolean callback(WinDef.HWND wnd, int lParam) {
                IntByReference dwID = new IntByReference();
                MyUser32.INSTANCE.GetWindowThreadProcessId(wnd, dwID);
                if (dwID.getValue() == lParam) {
                    MyUser32.INSTANCE.PostMessageA(wnd, 16, null, null);
                    messagePosted.set(true);
                }
                return true;
            }
        };
        MyUser32.INSTANCE.EnumWindows(closeWindow, this._pid);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        if (!messagePosted.get()) {
            this.log("seems the process does not have a window");
            this.sendCtnrlC();
        }
        if (timeout > 0) {
            this.waitFor(timeout);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.isRunning()) {
            this.log("process is not polite within " + timeout + "ms -> hard kill");
            return this.kill(code);
        }
        this._pid = -1;
        this.setExitCode(code);
        return true;
    }

    public void sendCtnrlC() {
        if (this._pid <= 0) {
            return;
        }
        this.log("try sending cntrl-c to the process");
        if (MyKernel32.INSTANCE.AttachConsole(this._pid)) {
            boolean setConsoleCtrlHandlerOK;
            boolean createCtrlEventOK;
            boolean removeConsoleCtrlHandlerOK = MyKernel32.INSTANCE.SetConsoleCtrlHandler(null, true);
            if (!removeConsoleCtrlHandlerOK) {
                int err = MyKernel32.INSTANCE.GetLastError();
                this.log("sendCtnrlC [" + this._pid + "] error executing removeConsoleCtrlHandler: " + err);
                this.log("sendCtnrlC [" + this._pid + "] message: " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
            }
            if (!(createCtrlEventOK = MyKernel32.INSTANCE.GenerateConsoleCtrlEvent(0, 0))) {
                int err = MyKernel32.INSTANCE.GetLastError();
                this.log("sendCtnrlC [" + this._pid + "] error executing createCtrlEvent: " + err);
                this.log("sendCtnrlC [" + this._pid + "] message: " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
            }
            this.waitFor(2000L);
            boolean freeConsoleOK = MyKernel32.INSTANCE.FreeConsole();
            if (!freeConsoleOK) {
                int err = MyKernel32.INSTANCE.GetLastError();
                this.log("sendCtnrlC [" + this._pid + "] error executing freeConsole " + err);
                this.log("sendCtnrlC [" + this._pid + "] message: " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
            }
            if (!(setConsoleCtrlHandlerOK = MyKernel32.INSTANCE.SetConsoleCtrlHandler(null, false))) {
                int err = MyKernel32.INSTANCE.GetLastError();
                this.log("sendCtnrlC [" + this._pid + "] error executing setConsoleCtrlHandler: " + err);
                this.log("sendCtnrlC [" + this._pid + "] message: " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
            }
        } else {
            int err = MyKernel32.INSTANCE.GetLastError();
            this.log("sendCtnrlC [" + this._pid + "] error in send cntrl-c: AttachConsole failed errorCode: " + err);
            this.log("sendCtnrlC [" + this._pid + "] message: " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
        }
    }

    @Override
    public boolean kill(int code) {
        boolean result = false;
        try {
            if (this._pid <= 0) {
                this.log("cannot kill process with pid " + this._pid);
                return false;
            }
            if (!this.isRunning()) {
                this._pid = -1;
                return false;
            }
            int i = 0;
            if (this._processInformation != null && this._processInformation.hProcess != null) {
                while (!result && i < 10) {
                    if (this._processInformation != null && this._processInformation.hProcess != null) {
                        result = MyKernel32.INSTANCE.TerminateProcess(this._processInformation.hProcess, code);
                        if (result) continue;
                        this.log("kill of process with PID " + this._pid + " failed: OS Error #" + MyKernel32.INSTANCE.GetLastError());
                        ++i;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    Thread.sleep(1000L);
                    result = !this.isRunning();
                }
            }
            Thread.sleep(100L);
            if (!this.isRunning()) {
                this._pid = -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = true;
        }
        if (!result) {
            this.log("kill failed: " + this._pid + " process still running");
        }
        return result;
    }

    public static boolean kill(int pid, int code) {
        if (pid <= 0) {
            return false;
        }
        WinNT.HANDLE hProcess = MyKernel32.INSTANCE.OpenProcess(1, false, pid);
        boolean result = MyKernel32.INSTANCE.TerminateProcess(hProcess, code);
        Thread.yield();
        if (!result) {
            System.out.println("process kill failed: " + pid + " code=" + code);
        }
        MyKernel32.INSTANCE.CloseHandle(hProcess);
        return result;
    }

    public static Map[] getProcessMaps(int pid) {
        int size;
        HashMap<Integer, MyKernel32.PROCESSENTRY32> processMap = new HashMap<Integer, MyKernel32.PROCESSENTRY32>();
        MultiValueMap childrenMap = new MultiValueMap();
        Map[] result = new Map[]{processMap, childrenMap};
        Pointer processes = MyKernel32.INSTANCE.CreateToolhelp32Snapshot(2, 0);
        if (processes == null) {
            System.out.println("note: task list is empty ");
            return result;
        }
        MyKernel32.PROCESSENTRY32 me = new MyKernel32.PROCESSENTRY32();
        me.szExeFile = new char[260];
        me.dwSize = size = me.size();
        if (MyKernel32.INSTANCE.Process32First(processes, me)) {
            do {
                if (me.th32ProcessID > 0) {
                    processMap.put(new Integer(me.th32ProcessID), me);
                }
                if (me.th32ParentProcessID <= 0 || processMap.get(new Integer(me.th32ParentProcessID)) == null) continue;
                childrenMap.put(new Integer(me.th32ParentProcessID), new Integer(me.th32ProcessID));
            } while (MyKernel32.INSTANCE.Process32Next(processes, me));
        } else {
            System.out.println("get process list: cannot access first process in list ");
        }
        MyKernel32.INSTANCE.CloseHandle(processes);
        return result;
    }

    public static List getProcessTree(int pid) {
        Map[] maps = WindowsXPProcess.getProcessMaps(pid);
        Map processMap = maps[0];
        Map childrenMap = maps[1];
        ArrayList<Integer> pids = new ArrayList<Integer>();
        pids.add(new Integer(pid));
        return WindowsXPProcess.getProcessTree(childrenMap, pids);
    }

    static List getProcessTree(Map childrenMap, Collection pids) {
        ArrayList result = new ArrayList();
        if (pids == null) {
            return result;
        }
        if (pids.isEmpty()) {
            return result;
        }
        for (Integer i : pids) {
            result.addAll(WindowsXPProcess.getProcessTree(childrenMap, (Collection)childrenMap.get(i)));
        }
        result.addAll(pids);
        return result;
    }

    @Override
    public boolean killTree(int code) {
        if (this._pid <= 0) {
            this.log("cannot kill process with pid " + this._pid);
            return false;
        }
        if (!this.isRunning()) {
            return false;
        }
        boolean result = true;
        List tree = WindowsXPProcess.getProcessTree(this._pid);
        for (int retry = 0; tree.size() < 2 && retry < 20; ++retry) {
            if (this._debug) {
                this.log("killTree: getProcessTree error: retrying ");
            }
            tree = WindowsXPProcess.getProcessTree(this._pid);
        }
        Iterator it = tree.iterator();
        while (it.hasNext()) {
            int pid = (Integer)it.next();
            if (pid == this._pid) continue;
            result = result && WindowsXPProcess.kill(pid, code);
        }
        result = result && this.kill(code);
        return result;
    }

    @Override
    public int getExitCode() {
        int result = 0;
        if (this._exitCode < 0 && this._processInformation != null) {
            result = this.getExitCodeInternal();
            if (result != 259) {
                this.setExitCode(result);
            } else {
                this.setExitCode(-2);
            }
        }
        if (this.isDebug()) {
            this.log("getExitCode " + this._exitCode + " processINFO==null=" + (this._processInformation == null));
        }
        return this._exitCode;
    }

    @Override
    public boolean isRunning() {
        boolean result;
        if (this._pid <= 0) {
            if (this.isDebug()) {
                this.log("is running: false pid=(" + this._pid + "<=0)");
            }
            return false;
        }
        if (this._processInformation == null) {
            if (this.isDebug()) {
                this.log("is running: _processInformation == null pid=" + this._pid);
            }
            return false;
        }
        boolean bl = result = this.getExitCode() == -2 && this._pid >= 0;
        if (this.isDebug()) {
            this.log("is running: " + result + " " + this._pid + " " + this._exitCode);
        }
        return result;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this._processInformation != null) {
            if (this._teeName != null && this._inputStream != null) {
                try {
                    this._inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    this._outputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    this._errorStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this._inputStream = null;
                this._outputStream = null;
                this._errorStream = null;
                new File(this._tmpPath, "in_" + this._teeName).delete();
                new File(this._tmpPath, "out_" + this._teeName).delete();
                new File(this._tmpPath, "err_" + this._teeName).delete();
            }
            if (this.outRead != null && this.outRead.getValue() != Pointer.NULL) {
                this.outRead = null;
            }
            if (this.errRead != null && this.errRead.getValue() != Pointer.NULL) {
                this.errRead = null;
            }
            if (this.inWrite != null && this.inWrite.getValue() != Pointer.NULL) {
                this.inWrite = null;
            }
            if (this._processInformation.hThread != null && !this._processInformation.hThread.equals((Object)Pointer.NULL)) {
                MyKernel32.INSTANCE.CloseHandle(this._processInformation.hThread);
            }
            if (this._processInformation.hProcess != null && !this._processInformation.hProcess.equals((Object)Pointer.NULL)) {
                MyKernel32.INSTANCE.CloseHandle(this._processInformation.hProcess);
            }
            if (this._cpuCounter != null) {
                this._cpuCounter.close();
                this._cpuCounter = null;
            }
            if (this._vMemCounter != null) {
                this._vMemCounter.close();
                this._vMemCounter = null;
            }
            if (this._pMemCounter != null) {
                this._pMemCounter.close();
                this._pMemCounter = null;
            }
            if (this._pfCounter != null) {
                this._pfCounter.close();
                this._pfCounter = null;
            }
            if (this._threadCounter != null) {
                this._threadCounter.close();
                this._threadCounter = null;
            }
            if (this._handleCounter != null) {
                this._handleCounter.close();
                this._handleCounter = null;
            }
        }
        if (this._debug) {
            this.log("process handles destroyed " + this._pid);
        }
        this._processInformation = null;
        this._startupInfo = null;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    boolean readVirtualMemoryToStructure(Pointer baseAddress, Structure goal) {
        int size = goal.size();
        int ret = Ntdll.INSTANCE.ZwReadVirtualMemory(this._processInformation.hProcess.getPointer(), baseAddress, goal.getPointer(), size, null);
        if (ret != 0) {
            this.log("pid " + this._pid + " ZwReadVirtualMemory returns " + Integer.toHexString(ret));
        }
        goal.read();
        return ret == 0;
    }

    boolean readVirtualMemoryToMemory(Pointer baseAddress, Memory goal) {
        int size = (int)goal.size();
        int ret = Ntdll.INSTANCE.ZwReadVirtualMemory(this._processInformation.hProcess.getPointer(), baseAddress, (Pointer)goal, size, null);
        if (ret != 0) {
            if (ret == -2147483635) {
                this.log("pid " + this._pid + " ZwReadVirtualMemory returns " + Integer.toHexString(ret) + " partial copy ");
            } else {
                this.log("pid " + this._pid + " ZwReadVirtualMemory returns " + Integer.toHexString(ret));
            }
        }
        return ret == 0;
    }

    long readProcessMemory(Pointer baseAddress, Memory goal) {
        NativeLong sizeAvalaible = new NativeLong(goal.size());
        NativeLongByReference bytesReadRefernce = new NativeLongByReference();
        boolean ret = MyKernel32.INSTANCE.ReadProcessMemory(this._processInformation.hProcess.getPointer(), baseAddress, (Pointer)goal, sizeAvalaible, bytesReadRefernce);
        if (!ret) {
            this.log("pid " + this._pid + " ReadProcessMemory returns " + ret);
        }
        long bytesRead = bytesReadRefernce.getValue().longValue();
        return bytesRead;
    }

    String getCommandLineInternal() {
        String result = "?";
        Ntdll.PROCESS_BASIC_INFORMATION pbi = null;
        pbi = new Ntdll.PROCESS_BASIC_INFORMATION();
        IntByReference returnLength = new IntByReference();
        WinNT.HANDLE hProcess = this._processInformation.hProcess;
        int pbiSize = pbi.size();
        int ret = Ntdll.INSTANCE.ZwQueryInformationProcess(hProcess, 0, pbi.getPointer(), pbiSize, returnLength);
        if (ret == 0) {
            Ntdll.PEB peb;
            pbi.read();
            if (pbi.PebBaseAddress != null && this.readVirtualMemoryToStructure(pbi.PebBaseAddress, peb = new Ntdll.PEB()) && peb.ProcessParameters != null) {
                Ntdll.RTL_USER_PROCESS_PARAMETERS userParams = new Ntdll.RTL_USER_PROCESS_PARAMETERS();
                int userParamsSize = userParams.size();
                if (this.readVirtualMemoryToStructure(peb.ProcessParameters, userParams)) {
                    Memory stringBuffer;
                    if (userParams.CommandLine.MaximumLength > 0 && this.readVirtualMemoryToMemory(userParams.CommandLine.Buffer, stringBuffer = new Memory((long)userParams.CommandLine.MaximumLength))) {
                        result = stringBuffer.getWideString(0L);
                    }
                    if (userParams.CurrentDirectoryPath.MaximumLength > 0 && this.readVirtualMemoryToMemory(userParams.CurrentDirectoryPath.Buffer, stringBuffer = new Memory((long)userParams.CurrentDirectoryPath.MaximumLength))) {
                        this._workingDir = stringBuffer.getWideString(0L);
                    }
                    if (userParams.WindowTitle.MaximumLength > 0 && this.readVirtualMemoryToMemory(userParams.WindowTitle.Buffer, stringBuffer = new Memory((long)userParams.WindowTitle.MaximumLength))) {
                        this._title = stringBuffer.getWideString(0L);
                    }
                    if (userParams.Environment != null) {
                        MyKernel32.MEMORY_BASIC_INFORMATION memInfo = new MyKernel32.MEMORY_BASIC_INFORMATION();
                        int memInfoSize = memInfo.size();
                        int bytesRead = MyKernel32.INSTANCE.VirtualQueryEx(hProcess.getPointer(), userParams.Environment, memInfo.getPointer(), memInfoSize);
                        memInfo.read();
                        if (bytesRead == 0) {
                            this._logger.warning("error getting environment in VirtualQueryEx " + Native.getLastError());
                        } else if (1 == memInfo.Protect || 16 == memInfo.Protect) {
                            this._logger.warning("error getting environment in VirtualQueryEx no access right");
                        } else {
                            long envBlockSize = Pointer.nativeValue((Pointer)memInfo.RegionSize);
                            long envSize = Math.min(envBlockSize, 32767L);
                            Memory mem = new Memory(envBlockSize);
                            this.readProcessMemory(userParams.Environment, mem);
                            ArrayList<String> envStrings = new ArrayList<String>();
                            String env = null;
                            int l = 0;
                            while (!"".equals(env)) {
                                env = mem.getWideString((long)l);
                                if (env != null && env.length() != 0) {
                                    envStrings.add(env);
                                    l += env.length() * 2 + 2;
                                }
                                if (env != null) continue;
                            }
                            this.parseEnvString(envStrings);
                        }
                    }
                }
            }
        }
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    private void parseEnvString(List<String> envStrings) {
        if (envStrings == null || envStrings.size() == 0) {
            return;
        }
        for (String str : envStrings) {
            String[] var = str.split("=");
            if (var.length != 2) continue;
            this._environment.add(new String[]{var[0], var[1]});
        }
    }

    String getCommandLineInternal64() {
        this.log("get command internal 64 " + this.getPid());
        String result = "?";
        Ntdll.PROCESS_BASIC_INFORMATION pbi = null;
        pbi = new Ntdll.PROCESS_BASIC_INFORMATION();
        IntByReference returnLength = new IntByReference();
        WinNT.HANDLE hProcess = this._processInformation.hProcess;
        int size = pbi.size();
        int ret = Ntdll.INSTANCE.ZwQueryInformationProcess(hProcess, 0, pbi.getPointer(), size, returnLength);
        if (ret == 0) {
            Memory stringBuffer;
            Ntdll.RTL_USER_PROCESS_PARAMETERS userParams;
            Ntdll.PEB64 peb;
            pbi.read();
            if (pbi.PebBaseAddress != null && this.readVirtualMemoryToStructure(pbi.PebBaseAddress, peb = new Ntdll.PEB64()) && peb.ProcessParameters != null && this.readVirtualMemoryToStructure(peb.ProcessParameters, userParams = new Ntdll.RTL_USER_PROCESS_PARAMETERS()) && this.readVirtualMemoryToMemory(userParams.CommandLine.Buffer, stringBuffer = new Memory((long)userParams.CommandLine.Length))) {
                result = stringBuffer.getWideString(0L);
            }
        } else {
            this.log("pid " + this._pid + " ZwQueryInformationProcess returns " + Integer.toHexString(ret));
        }
        return result;
    }

    public String getCommandLineInternalWMI() {
        String result = "?";
        WindowsXPProcess p = null;
        for (int k = 0; k < 3 && "?".equals(result); ++k) {
            try {
                int ec;
                p = new WindowsXPProcess();
                new File("wmic.tmp").delete();
                p.setCommand("cmd /C wmic process where processid=" + this.getPid() + " get commandline > wmic.tmp");
                p.setVisible(false);
                p.start();
                p.waitFor(30000L);
                if (p.isRunning()) {
                    p.kill(99);
                }
                if ((ec = p.getExitCode()) != 0) {
                    this.log("unexptected exit code in getCommandLineInternalWMI: " + ec);
                }
                BufferedReader br = new BufferedReader(new FileReader("wmic.tmp"));
                String l = "?";
                try {
                    br.readLine();
                    br.readLine();
                    l = br.readLine();
                    if (l.codePointAt(0) == 0) {
                        StringBuffer s = new StringBuffer();
                        for (int i = 0; i < l.length(); ++i) {
                            if (l.codePointAt(i) == 0) continue;
                            s.append(l.charAt(i));
                        }
                        l = s.toString();
                    }
                    result = l;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                br.close();
                p.destroy();
                continue;
            }
            catch (Exception e) {
                if (this._debug) {
                    this.log("Error in getCommandLineInternalWMI");
                }
                e.printStackTrace();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return result;
                }
                if (p == null) continue;
                p.destroy();
            }
        }
        return result;
    }

    public long getTotalCPU() {
        long result = -1L;
        if (!this.isRunning()) {
            return -1L;
        }
        LongByReference lpCreationTime = new LongByReference();
        LongByReference lpExitTime = new LongByReference();
        LongByReference lpKernelTime = new LongByReference();
        LongByReference lpUserTime = new LongByReference();
        if (MyKernel32.INSTANCE.GetProcessTimes(this._processInformation.hProcess, lpCreationTime, lpExitTime, lpKernelTime, lpUserTime)) {
            result = lpUserTime.getValue() + lpKernelTime.getValue();
        }
        return result;
    }

    public static int currentProcessId() {
        return MyKernel32.INSTANCE.GetCurrentProcessId();
    }

    public static int processIdOfActiveWindow() {
        WinDef.HWND w = MyUser32.INSTANCE.GetForegroundWindow();
        IntByReference result = new IntByReference();
        MyUser32.INSTANCE.GetWindowThreadProcessId(w, result);
        return result.getValue();
    }

    @Override
    public int getCurrentCpu() {
        PdhCounter c = this.getCpuCounter();
        if (c != null) {
            return c.getIntValue();
        }
        return -1;
    }

    private PdhCounter getCpuCounter() {
        if (this._cpuCounter == null) {
            this._cpuCounter = Pdh.getProcessEnglishCounter(this._pid, "% Processor Time");
        }
        return this._cpuCounter;
    }

    @Override
    public long getCurrentPhysicalMemory() {
        if (!this.isRunning()) {
            return -1L;
        }
        PdhCounter c = this.getPMemCounter();
        if (c == null) {
            return -1L;
        }
        if (Platform.is64Bit()) {
            return c.getLongValue();
        }
        return c.getIntValue();
    }

    private PdhCounter getPMemCounter() {
        if (this._pMemCounter == null) {
            this._pMemCounter = Pdh.getProcessEnglishCounter(this._pid, "Private Bytes");
        }
        return this._pMemCounter;
    }

    @Override
    public long getCurrentVirtualMemory() {
        if (!this.isRunning() || this.getVMemCounter() == null) {
            return -1L;
        }
        PdhCounter c = this.getVMemCounter();
        if (c == null) {
            return -1L;
        }
        return c.getLongValue();
    }

    private PdhCounter getVMemCounter() {
        if (this._vMemCounter == null) {
            this._vMemCounter = Pdh.getProcessEnglishCounter(this._pid, "Virtual Bytes");
        }
        return this._vMemCounter;
    }

    @Override
    public int getCurrentPageFaults() {
        PdhCounter counter = this.getPfCounter();
        if (counter != null) {
            return counter.getIntValue();
        }
        return -1;
    }

    private PdhCounter getPfCounter() {
        if (this._pfCounter == null) {
            this._pfCounter = Pdh.getProcessEnglishCounter(this._pid, "Page Faults/sec");
        }
        return this._pfCounter;
    }

    @Override
    public Collection getChildren() {
        return WindowsXPProcess.getProcessTree(this._pid);
    }

    public static void main(String[] args) throws InterruptedException {
        int pid = 5688;
        Process p = WindowsXPProcess.getProcess(pid);
        System.out.println(p.getCurrentCpu());
        System.out.println(p.getCommand());
    }

    @Override
    public boolean reconnectStreams() {
        if (this._teeName != null) {
            try {
                this._inputStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "out_" + this._teeName));
                this._errorStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "err_" + this._teeName));
                this._outputStream = new CyclicBufferFilePrintStream(new File(this._tmpPath, "in_" + this._teeName));
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private void writefd(FileDescriptor fd, Pointer pointer) {
        try {
            Field handleField = FileDescriptor.class.getDeclaredField("handle");
            handleField.setAccessible(true);
            Field peerField = Pointer.class.getDeclaredField("peer");
            peerField.setAccessible(true);
            long value = peerField.getLong(pointer);
            handleField.setLong(fd, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String currentUser() {
        String result = System.getenv("USERDOMAIN") + "\\" + System.getenv("USERNAME");
        result = result.toUpperCase();
        return result;
    }

    public String currentUserName() {
        String result = System.getProperty("user.name");
        if (result == null) {
            return "";
        }
        result = result.toUpperCase();
        return result;
    }

    public String currentUserDomain() {
        String result = System.getenv("USERDOMAIN");
        if (result == null) {
            return "";
        }
        return result.toUpperCase();
    }

    public String standardizeUser(String user) {
        if (user == null || "".equals(user)) {
            return null;
        }
        if (user.indexOf("\\") == -1) {
            return this.currentUserDomain() + "\\" + user.toUpperCase();
        }
        return user.toUpperCase();
    }

    boolean doesUserHavePrivilege(String lpPrivilegeName) {
        PointerByReference hToken = new PointerByReference();
        IntByReference dwSize = new IntByReference();
        MyAdvapi.LUID PrivilegeLuid = new MyAdvapi.LUID();
        boolean bResult = false;
        if (!MyAdvapi.INSTANCE.OpenProcessToken(MyKernel32.INSTANCE.GetCurrentProcess(), 8, hToken)) {
            return false;
        }
        MyAdvapi.INSTANCE.GetTokenInformation(hToken.getValue(), 3, null, 0, dwSize);
        Memory lpPrivileges = new Memory((long)dwSize.getValue());
        if (!MyAdvapi.INSTANCE.GetTokenInformation(hToken.getValue(), 3, lpPrivileges, dwSize.getValue(), dwSize)) {
            return false;
        }
        MyKernel32.INSTANCE.CloseHandle(hToken.getValue());
        if (!MyAdvapi.INSTANCE.LookupPrivilegeValueA(null, lpPrivilegeName, PrivilegeLuid)) {
            return false;
        }
        MyAdvapi.TOKEN_PRIVILEGES privileges = new MyAdvapi.TOKEN_PRIVILEGES((Pointer)lpPrivileges);
        for (int i = 0; i < privileges.PrivilegeCount; ++i) {
            if (privileges.Privileges[i].Luid.HighPart != PrivilegeLuid.HighPart || privileges.Privileges[i].Luid.LowPart != PrivilegeLuid.LowPart) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCurrentHandles() {
        PdhCounter counter = this.getHandlesCounter();
        if (counter != null) {
            return counter.getIntValue();
        }
        return -1;
    }

    private PdhCounter getHandlesCounter() {
        if (this._handleCounter == null) {
            this._handleCounter = Pdh.getProcessEnglishCounter(this._pid, "Handle Count");
        }
        return this._handleCounter;
    }

    @Override
    public int getCurrentThreads() {
        if (!this.isRunning() || this.getThreadsCounter() == null) {
            return -1;
        }
        PdhCounter c = this.getThreadsCounter();
        if (c == null) {
            return -1;
        }
        return c.getIntValue();
    }

    private PdhCounter getThreadsCounter() {
        if (this._threadCounter == null) {
            this._threadCounter = Pdh.getProcessEnglishCounter(this._pid, "Thread Count");
        }
        return this._threadCounter;
    }

    @Override
    public boolean isTerminated() {
        return this._started && !this.isRunning();
    }

    @Override
    public boolean changeWorkingDir(String name) {
        String dir;
        File f = new File(name);
        if (!f.exists() || !f.isDirectory()) {
            System.out.println("setWorkingDirectory failed. file not found " + name);
            return false;
        }
        try {
            dir = f.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        boolean result = MyKernel32.INSTANCE.SetCurrentDirectoryW(new WString(dir));
        if (result) {
            System.setProperty("user.dir", dir);
        }
        return result;
    }

    public boolean startElevated() {
        String file = this.getCmdFile();
        if (file == null) {
            this.log("startElevated: Error: error in command");
            return false;
        }
        String parameters = this.getCmdParameters();
        if (this._debug) {
            this.log("elevated exec: " + file + " " + parameters);
        }
        Shell32.SHELLEXECUTEINFO lpExecInfo = new Shell32.SHELLEXECUTEINFO();
        lpExecInfo.fMask = 64;
        lpExecInfo.hwnd = null;
        lpExecInfo.lpFile = file;
        lpExecInfo.lpVerb = "runas";
        lpExecInfo.nShow = 3;
        lpExecInfo.lpParameters = parameters;
        lpExecInfo.cbSize = lpExecInfo.size();
        boolean result = Shell32.INSTANCE.ShellExecuteEx(lpExecInfo);
        if (!result) {
            int err = Native.getLastError();
            System.out.println("Error: " + err + " " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
        } else {
            this._pid = MyKernel32.INSTANCE.GetProcessId(lpExecInfo.hProcess);
            this._processInformation = new MyKernel32.PROCESS_INFORMATION();
            this._processInformation.dwProcessId = this._pid;
            this._processInformation.hProcess = lpExecInfo.hProcess;
        }
        return result;
    }

    private String getCmdParameters() {
        String result = "";
        int i = 0;
        if (this._arrCmd != null) {
            for (String cmd : this._arrCmd) {
                if (i != 0) {
                    result = cmd.startsWith("\"") ? result + cmd + " " : result + '\"' + cmd + "\" ";
                }
                ++i;
            }
        } else {
            result = this._cmd.startsWith("\"") ? this._cmd.substring(this._cmd.indexOf("\" ", 1) + 2) : this._cmd.substring(this._cmd.indexOf(" "));
        }
        if ("".equals(result)) {
            result = null;
        }
        return result;
    }

    private String getCmdFile() {
        if (this._arrCmd != null) {
            return this._arrCmd[0];
        }
        if (this._cmd != null) {
            if (this._cmd.startsWith("\"")) {
                return this._cmd.substring(1, this._cmd.indexOf("\" ", 1));
            }
            return this._cmd.substring(0, this._cmd.indexOf(" "));
        }
        return null;
    }

    public boolean isElevated() {
        if (this._isElevated > -1) {
            return this._isElevated == 1;
        }
        this._isElevated = this.isElevatedInternal();
        return this._isElevated == 1;
    }

    private int isElevatedInternal() {
        try {
            PointerByReference hToken = new PointerByReference();
            IntByReference dwSize = new IntByReference();
            if (!MyAdvapi.INSTANCE.OpenProcessToken(MyKernel32.INSTANCE.GetCurrentProcess(), 8, hToken)) {
                return -1;
            }
            MyAdvapi.INSTANCE.GetTokenInformation(hToken.getValue(), 20, null, 0, dwSize);
            Memory lpElevation = new Memory((long)dwSize.getValue());
            if (!MyAdvapi.INSTANCE.GetTokenInformation(hToken.getValue(), 20, lpElevation, dwSize.getValue(), dwSize)) {
                return -1;
            }
            MyKernel32.INSTANCE.CloseHandle(hToken.getValue());
            MyAdvapi.TOKEN_ELEVATION elevation = new MyAdvapi.TOKEN_ELEVATION((Pointer)lpElevation);
            return elevation.isElevated() ? 1 : 0;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean elevateMe() {
        WindowsXPProcess me = (WindowsXPProcess)WindowsXPProcess.getProcess(WindowsXPProcess.currentProcessId());
        System.out.println("elevating command line " + me.getCommand());
        if (PlatformEx.isWinVista() && !me.isElevated()) {
            WindowsXPProcess elevatedMe = new WindowsXPProcess();
            elevatedMe.setCommand(me.getCommand());
            if (me._arrCmd != null) {
                elevatedMe.setCommand(me._arrCmd);
            }
            elevatedMe.setDebug(me._debug);
            elevatedMe.setLogger(me._logger);
            me.destroy();
            boolean result = elevatedMe.startElevated();
            if (result) {
                elevatedMe.waitFor();
                elevatedMe.destroy();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProcessPriority(int pid, int priority) {
        WinNT.HANDLE hProcess = null;
        try {
            hProcess = MyKernel32.INSTANCE.OpenProcess(0x1F0FFF, false, pid);
            if (hProcess == null) {
                hProcess = MyKernel32.INSTANCE.OpenProcess(1024, false, pid);
            }
            if (hProcess == null) {
                return;
            }
            MyKernel32.INSTANCE.SetPriorityClass(hProcess, WindowsXPProcess.getPriorityFlag(priority));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            if (hProcess != null) {
                MyKernel32.INSTANCE.CloseHandle(hProcess);
            }
        }
    }

    private boolean isActiveWindow(WinDef.HWND wnd) {
        WinUser.WINDOWINFO pwi = new WinUser.WINDOWINFO();
        pwi.size();
        if (MyUser32.INSTANCE.GetWindowInfo(wnd, pwi)) {
            pwi.read();
            return pwi.dwWindowStatus == 1;
        }
        return false;
    }

    public WinDef.HWND getActiveWindow() {
        if (this.lastActiveWindow != null && this.isActiveWindow(this.lastActiveWindow)) {
            return this.lastActiveWindow;
        }
        MyUser32.WNDENUMPROC findActiveWindow = new MyUser32.WNDENUMPROC(){

            @Override
            public boolean callback(WinDef.HWND wnd, int lParam) {
                IntByReference dwID = new IntByReference();
                MyUser32.INSTANCE.GetWindowThreadProcessId(wnd, dwID);
                if (dwID.getValue() == lParam) {
                    if (WindowsXPProcess.this.lastActiveWindow == null) {
                        byte[] windowText = new byte[512];
                        MyUser32.INSTANCE.GetWindowTextA(wnd, windowText, 512);
                        String wText = Native.toString(windowText);
                        System.out.println(wText);
                        if (!wText.isEmpty()) {
                            WindowsXPProcess.this.lastActiveWindow = wnd;
                        }
                    }
                    if (WindowsXPProcess.this.isActiveWindow(wnd)) {
                        WindowsXPProcess.this.lastActiveWindow = wnd;
                    }
                }
                return true;
            }
        };
        MyUser32.INSTANCE.EnumWindows(findActiveWindow, this._pid);
        byte[] windowText = new byte[512];
        return this.lastActiveWindow;
    }

    public void sendKey(char key) {
        if (this._pid <= 0) {
            return;
        }
        if (this.getActiveWindow() != null) {
            byte[] windowText = new byte[512];
            MyUser32.INSTANCE.GetWindowTextA(this.lastActiveWindow, windowText, 512);
            String wText = Native.toString(windowText);
            wText = wText.isEmpty() ? "" : "; text: " + wText;
            System.out.println("sending key " + key + " to " + wText);
            MyUser32.INSTANCE.SendMessageW(this.lastActiveWindow, 256, key, 0);
            MyUser32.INSTANCE.SendMessageW(this.lastActiveWindow, 257, key, 0);
        } else {
            System.out.println("no window found");
        }
    }

    public long getUptime() {
        return MyKernel32.INSTANCE.GetTickCount() / 1000;
    }

    private static void setShutdownPrivileges() {
        WinNT.HANDLEByReference token = new WinNT.HANDLEByReference();
        Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 32, token);
        WinNT.LUID luid = new WinNT.LUID();
        Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeShutdownPrivilege", luid);
        WinNT.TOKEN_PRIVILEGES tp = new WinNT.TOKEN_PRIVILEGES(1);
        tp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
        Advapi32.INSTANCE.AdjustTokenPrivileges(token.getValue(), false, tp, 0, null, new IntByReference(0));
    }

    public void reboot() {
        WindowsXPProcess.setShutdownPrivileges();
        if (!MyUser32.INSTANCE.ExitWindowsEx(new WinDef.UINT((long)(2 + 4)), new WinDef.DWORD(Integer.MIN_VALUE)).booleanValue()) {
            int err = MyKernel32.INSTANCE.GetLastError();
            System.out.println("error executing reboot " + err + " " + Kernel32Util.formatMessageFromLastErrorCode((int)err));
        }
    }

    public Map<String, String> getOSProcessEnv() {
        Map result = Kernel32Util.getEnvironmentVariables();
        return result;
    }

    @Override
    public void handleAffinity() {
    }

    public static interface MyKernel32
    extends Kernel32 {
        public static final MyKernel32 INSTANCE = Native.loadLibrary("kernel32", MyKernel32.class);
        public static final int CREATE_NO_WINDOW = 0x8000000;
        public static final int CREATE_UNICODE_ENVIRONMENT = 1024;
        public static final int CREATE_NEW_CONSOLE = 16;
        public static final int DETACHED_PROCESS = 8;
        public static final int SW_SHOWMINIMIZED = 2;
        public static final int SW_SHOWNOACTIVATE = 4;
        public static final int STARTF_USESHOWWINDOW = 1;
        public static final int STARTF_USESTDHANDLES = 256;
        public static final int IDLE_PRIORITY_CLASS = 64;
        public static final int BELOW_NORMAL_PRIORITY_CLASS = 16384;
        public static final int NORMAL_PRIORITY_CLASS = 32;
        public static final int ABOVE_NORMAL_PRIORITY_CLASS = 32768;
        public static final int HIGH_PRIORITY_CLASS = 128;
        public static final int REALTIME_PRIORITY_CLASS = 256;
        public static final int INFINITE = -1;
        public static final int STILL_ACTIVE = 259;
        public static final int TH32CS_SNAPPROCESS = 2;
        public static final int WAIT_FAILED = -1;
        public static final int WAIT_TIMEOUT = 258;
        public static final int WAIT_OBJECT_0 = 0;
        public static final int WAIT_ABANDONED = 128;
        public static final int MAX_PATH = 260;
        public static final int PROCESS_TERMINATE = 1;
        public static final int PROCESS_QUERY_INFORMATION = 1024;
        public static final int STANDARD_RIGHTS_REQUIRED = 983040;
        public static final int SYNCHRONIZE = 0x100000;
        public static final int PROCESS_ALL_ACCESS = 0x1F0FFF;
        public static final int HANDLE_FLAG_INHERIT = 1;
        public static final int HANDLE_FLAG_PROTECT_FROM_CLOSE = 2;
        public static final int PIPE_ACCESS_OUTBOUND = 2;
        public static final int PIPE_ACCESS_INBOUND = 1;
        public static final int PIPE_WAIT = 0;
        public static final int PIPE_NOWAIT = 1;
        public static final int GENERIC_READ = Integer.MIN_VALUE;
        public static final Pointer INVALID_HANDLE_VALUE = Pointer.createConstant((int)-1);
        public static final int NMPWAIT_USE_DEFAULT_WAIT = 0;
        public static final int NMPWAIT_WAIT_FOREVER = -1;
        public static final int PAGE_NOACCESS = 1;
        public static final int PAGE_EXECUTE = 16;
        public static final int CTRL_C_EVENT = 0;
        public static final int CTRL_BREAK_EVENT = 1;

        public boolean ReadFile(Pointer var1, Memory var2, int var3, IntByReference var4, Structure var5);

        public int GetCurrentProcessId();

        public int GetProcessIdOfThread(Pointer var1);

        public boolean CreateProcessA(String var1, String var2, Structure var3, Structure var4, boolean var5, int var6, Structure var7, String var8, Structure var9, Structure var10);

        public boolean CreateProcessW(WString var1, WString var2, Structure var3, Structure var4, boolean var5, int var6, Memory var7, WString var8, Structure var9, Structure var10);

        public int WaitForSingleObject(Pointer var1, int var2);

        public boolean GetExitCodeProcess(WinNT.HANDLE var1, IntByReference var2);

        public boolean TerminateProcess(WinNT.HANDLE var1, int var2);

        public boolean GetProcessAffinityMask(WinNT.HANDLE var1, LongByReference var2, LongByReference var3);

        public boolean SetProcessAffinityMask(WinNT.HANDLE var1, long var2);

        public boolean SetPriorityClass(WinNT.HANDLE var1, int var2);

        public boolean CloseHandle(Pointer var1);

        public Pointer CreateToolhelp32Snapshot(int var1, int var2);

        public boolean Process32First(Pointer var1, Structure var2);

        public boolean Process32Next(Pointer var1, Structure var2);

        public WinNT.HANDLE OpenProcess(int var1, boolean var2, int var3);

        public boolean GetProcessTimes(WinNT.HANDLE var1, LongByReference var2, LongByReference var3, LongByReference var4, LongByReference var5);

        public int CreatePipe(PointerByReference var1, PointerByReference var2, Structure var3, int var4);

        public boolean SetHandleInformation(Pointer var1, int var2, int var3);

        public Pointer CreateNamedPipeA(String var1, int var2, int var3, int var4, int var5, int var6, int var7, SECURITY_ATTRIBUTES var8);

        public Pointer CreateFileA(String var1, int var2, int var3, SECURITY_ATTRIBUTES var4, int var5, int var6, Pointer var7);

        public boolean ConnectNamedPipe(Pointer var1, PointerByReference var2);

        public boolean WaitNamedPipeA(String var1, int var2);

        public boolean SetCurrentDirectoryA(String var1);

        public boolean SetCurrentDirectoryW(WString var1);

        public int VirtualQueryEx(Pointer var1, Pointer var2, Pointer var3, int var4);

        public boolean ReadProcessMemory(Pointer var1, Pointer var2, Pointer var3, NativeLong var4, NativeLongByReference var5);

        public int WTSGetActiveConsoleSessionId();

        public boolean AttachConsole(int var1);

        public boolean SetConsoleCtrlHandler(Callback var1, boolean var2);

        public boolean GenerateConsoleCtrlEvent(int var1, int var2);

        public boolean FreeConsole();

        public static class MEMORY_BASIC_INFORMATION
        extends Structure {
            public Pointer BaseAddress;
            public Pointer AllocationBase;
            public int AllocationProtect;
            public Pointer RegionSize;
            public int State;
            public int Protect;
            public int Type;

            protected List getFieldOrder() {
                return Arrays.asList("BaseAddress", "AllocationBase", "AllocationProtect", "RegionSize", "State", "Protect", "Type");
            }
        }

        public static class SECURITY_ATTRIBUTES
        extends Structure {
            public int nLength;
            public Pointer lpSecurityDescriptor;
            public boolean bInheritHandle;

            protected List getFieldOrder() {
                return Arrays.asList("nLength", "lpSecurityDescriptor", "bInheritHandle");
            }
        }

        public static class PROCESSENTRY32
        extends Structure {
            public int dwSize;
            public int cntUsage;
            public int th32ProcessID;
            public int th32DefaultHeapID;
            public int th32ModuleID;
            public int cntThreads;
            public int th32ParentProcessID;
            public int pcPriClassBase;
            public int dwFlags;
            public char[] szExeFile;

            protected List getFieldOrder() {
                return Arrays.asList("dwSize", "cntUsage", "th32ProcessID", "th32DefaultHeapID", "th32ModuleID", "cntThreads", "th32ParentProcessID", "pcPriClassBase", "dwFlags", "szExeFile");
            }
        }

        public static class STARTUPINFO
        extends Structure {
            public int cb;
            public WString lpReserved;
            public WString lpDesktop;
            public WString lpTitle;
            public int dwX;
            public int dwY;
            public int dwXSize;
            public int dwYSize;
            public int dwXCountChars;
            public int dwYCountChars;
            public int dwFillAttribute;
            public int dwFlags;
            public short wShowWindow;
            public short cbReserved2;
            public Pointer lpReserved2;
            public Pointer hStdInput;
            public Pointer hStdOutput;
            public Pointer hStdError;

            protected List getFieldOrder() {
                return Arrays.asList("cb", "lpReserved", "lpDesktop", "lpTitle", "dwX", "dwY", "dwXSize", "dwYSize", "dwXCountChars", "dwYCountChars", "dwFillAttribute", "dwFlags", "wShowWindow", "cbReserved2", "lpReserved2", "hStdInput", "hStdOutput", "hStdError");
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            public String toString() {
                return "" + this.hStdError + "/" + this.hStdOutput + "/" + this.hStdInput;
            }
        }

        public static class PROCESS_INFORMATION
        extends Structure {
            public WinNT.HANDLE hProcess = null;
            public Pointer hThread = null;
            public int dwProcessId = -1;
            public int dwThreadId = -1;

            protected List getFieldOrder() {
                return Arrays.asList("hProcess", "hThread", "dwProcessId", "dwThreadId");
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface MyAdvapi
    extends Advapi32 {
        public static final MyAdvapi INSTANCE = Native.loadLibrary("Advapi32", MyAdvapi.class, Options.UNICODE_OPTIONS);
        public static final int TokenPrivileges = 3;
        public static final int TokenUser = 1;
        public static final int TokenElevation = 20;
        public static final int SECURITY_DESCRIPTOR_MIN_LENGTH = 20;
        public static final int SECURITY_DESCRIPTOR_REVISION = 1;
        public static final int SE_PRIVILEGE_ENABLED = 2;
        public static final String SE_ASSIGNPRIMARYTOKEN_NAME = "SeAssignPrimaryTokenPrivilege";
        public static final String SE_INCREASE_QUOTA_NAME = "SeIncreaseQuotaPrivilege";
        public static final String SE_DEBUG_NAME = "SeDebugPrivilege";
        public static final String SE_TCB_NAME = "SeTcbPrivilege";
        public static final int STANDARD_RIGHTS_READ = 131072;
        public static final int STANDARD_RIGHTS_WRITE = 131072;
        public static final int TOKEN_QUERY = 8;
        public static final int TOKEN_ADJUST_PRIVILEGES = 32;
        public static final int TOKEN_ADJUST_GROUPS = 64;
        public static final int TOKEN_ADJUST_DEFAULT = 128;
        public static final int TOKEN_DUPLICATE = 2;
        public static final int TOKEN_IMPERSONATE = 4;
        public static final int TOKEN_READ = 131080;
        public static final int TOKEN_WRITE = 131296;
        public static final int LOGON_WITH_PROFILE = 1;
        public static final int LOGON_NETCREDENTIALS_ONLY = 2;
        public static final int LOGON32_LOGON_INTERACTIVE = 2;
        public static final int LOGON32_LOGON_NETWORK = 3;
        public static final int LOGON32_LOGON_BATCH = 4;
        public static final int LOGON32_LOGON_SERVICE = 5;
        public static final int LOGON32_LOGON_UNLOCK = 7;
        public static final int LOGON32_LOGON_NETWORK_CLEARTEXT = 8;
        public static final int LOGON32_LOGON_NEW_CREDENTIALS = 9;
        public static final int LOGON32_PROVIDER_DEFAULT = 0;
        public static final int LOGON32_PROVIDER_WINNT35 = 1;
        public static final int LOGON32_PROVIDER_WINNT40 = 2;
        public static final int LOGON32_PROVIDER_WINNT50 = 3;

        public boolean LookupAccountSidW(String var1, Pointer var2, Memory var3, IntByReference var4, Memory var5, IntByReference var6, IntByReference var7);

        public boolean GetTokenInformation(Pointer var1, int var2, Memory var3, int var4, IntByReference var5);

        public boolean InitializeSecurityDescriptor(Memory var1, int var2);

        public boolean SetSecurityDescriptorDacl(Pointer var1, boolean var2, Pointer var3, boolean var4);

        public boolean AdjustTokenPrivileges(Pointer var1, boolean var2, TOKEN_PRIVILEGES var3, int var4, PointerByReference var5, IntByReference var6);

        public boolean LookupPrivilegeValueA(String var1, String var2, LUID var3);

        public boolean OpenProcessToken(WinNT.HANDLE var1, int var2, PointerByReference var3);

        public boolean CreateProcessWithLogonW(WString var1, WString var2, WString var3, int var4, WString var5, WString var6, int var7, Memory var8, WString var9, Structure var10, Structure var11);

        public boolean LogonUserA(String var1, String var2, String var3, int var4, int var5, PointerByReference var6);

        public boolean LogonUserW(WString var1, WString var2, WString var3, int var4, int var5, PointerByReference var6);

        public boolean ImpersonateLoggedOnUser(Pointer var1);

        public boolean CreateProcessAsUserW(Pointer var1, WString var2, WString var3, Structure var4, Structure var5, boolean var6, int var7, Memory var8, WString var9, Structure var10, Structure var11);

        public boolean DuplicateTokenEx(Pointer var1, int var2, Pointer var3, int var4, int var5, PointerByReference var6);

        public static class SECURITY_ATTRIBUTES {
            public int nLength;
            public Pointer lpSecurityDescriptor;
            boolean bInheritHandle;
        }

        public static class TOKEN_PRIVILEGES
        extends Structure {
            public int PrivilegeCount = 1;
            public LUID_AND_ATTRIBUTES[] Privileges = new LUID_AND_ATTRIBUTES[1];

            protected List getFieldOrder() {
                return Arrays.asList("PrivilegeCount", "Privileges");
            }

            public TOKEN_PRIVILEGES() {
                this.Privileges[0] = new LUID_AND_ATTRIBUTES();
            }

            public TOKEN_PRIVILEGES(Pointer p) {
                this.PrivilegeCount = p.getInt(0L);
                this.Privileges = new LUID_AND_ATTRIBUTES[this.PrivilegeCount];
                this.useMemory(p);
                this.read();
            }
        }

        public static class LUID_AND_ATTRIBUTES
        extends Structure {
            public LUID Luid;
            public int Attributes;

            protected List getFieldOrder() {
                return Arrays.asList("Luid", "Attributes");
            }
        }

        public static class LUID
        extends Structure {
            public int LowPart;
            public int HighPart;

            protected List getFieldOrder() {
                return Arrays.asList("LowPart", "HighPart");
            }
        }

        public static class TOKEN_ELEVATION
        extends Structure {
            public int TokenIsElevated = 0;

            protected List getFieldOrder() {
                return Arrays.asList("TokenIsElevated");
            }

            public TOKEN_ELEVATION(Pointer p) {
                this.useMemory(p);
                this.read();
            }

            public boolean isElevated() {
                return this.TokenIsElevated != 0;
            }
        }

        public static class TOKEN_USER
        extends Structure {
            public SID_AND_ATTRIBUTES User;

            protected List getFieldOrder() {
                return Arrays.asList("User");
            }

            public TOKEN_USER(Pointer p) {
                this.useMemory(p);
                this.read();
            }
        }

        public static class SID_AND_ATTRIBUTES
        extends Structure {
            public Pointer Sid;
            public int Attributes;

            protected List getFieldOrder() {
                return Arrays.asList("Sid", "Attributes");
            }
        }
    }

    public static interface MyWtsapi32
    extends StdCallLibrary {
        public static final MyWtsapi32 INSTANCE = Native.loadLibrary("Wtsapi32", MyWtsapi32.class);

        public boolean WTSQueryUserToken(int var1, PointerByReference var2);
    }

    public static interface MyUser32
    extends User32 {
        public static final MyUser32 INSTANCE = Native.loadLibrary("User32", MyUser32.class);
        public static final int WM_CLOSE = 16;
        public static final int WM_QUIT = 18;
        public static final int WM_DESTROY = 2;
        public static final int WM_KEYDOWN = 256;
        public static final int WM_KEYUP = 257;
        public static final int WM_CHAR = 258;
        public static final int WM_SETFOCUS = 7;
        public static final int VK_CONTROL = 17;
        public static final int EWX_LOGOFF = 0;
        public static final int EWX_POWEROFF = 8;
        public static final int EWX_REBOOT = 2;
        public static final int EWX_FORCE = 4;
        public static final int EWX_FORCEIFHUNG = 16;
        public static final int SHTDN_REASON_FLAG_PLANNED = Integer.MIN_VALUE;

        public WinDef.HWND GetForegroundWindow();

        public int GetWindowThreadProcessId(Pointer var1, IntByReference var2);

        public int GetWindowTextA(WinDef.HWND var1, byte[] var2, int var3);

        public boolean GetWindowInfo(WinDef.HWND var1, WinUser.WINDOWINFO var2);

        public boolean PostThreadMessageA(int var1, int var2, int var3, int var4);

        public int WaitForInputIdle(WinNT.HANDLE var1, int var2);

        public void PostMessageA(WinDef.HWND var1, int var2, Pointer var3, Pointer var4);

        public void SendMessageW(WinDef.HWND var1, int var2, long var3, int var5);

        public boolean EnumWindows(WNDENUMPROC var1, int var2);

        public static interface WNDENUMPROC
        extends StdCallLibrary.StdCallCallback {
            public boolean callback(WinDef.HWND var1, int var2);
        }
    }

    public static interface Ntdll
    extends StdCallLibrary {
        public static final Ntdll INSTANCE = Native.loadLibrary("Ntdll", Ntdll.class);

        public int ZwReadVirtualMemory(Pointer var1, Pointer var2, Pointer var3, int var4, IntByReference var5);

        public int ZwQueryInformationProcess(WinNT.HANDLE var1, int var2, Pointer var3, int var4, IntByReference var5);

        public static class UNICODE_STRING
        extends Structure {
            public short Length = 0;
            public short MaximumLength;
            public Pointer Buffer;

            protected List getFieldOrder() {
                return Arrays.asList("Length", "MaximumLength", "Buffer");
            }
        }

        public static class RTL_DRIVE_LETTER_CURDIR
        extends Structure {
            public int Flags;
            public int Length;
            public int TimeStamp;
            public UNICODE_STRING DosPath;

            protected List getFieldOrder() {
                return Arrays.asList("Flags", "Length", "TimeStamp", "DosPath");
            }
        }

        public static class RTL_USER_PROCESS_PARAMETERS
        extends Structure {
            public int AllocationSize;
            public int Size;
            public int Flags;
            public int DebugFlags;
            public WinNT.HANDLE hConsole;
            public int ProcessGroup;
            public WinNT.HANDLE hStdInput;
            public WinNT.HANDLE hStdOutput;
            public WinNT.HANDLE hStdError;
            public UNICODE_STRING CurrentDirectoryPath;
            public Pointer CurrentDirectoryHandle;
            public UNICODE_STRING DllPath;
            public UNICODE_STRING ImagePathName;
            public UNICODE_STRING CommandLine;
            public Pointer Environment;
            public int dwX;
            public int dwY;
            public int dwXSize;
            public int dwYSize;
            public int dwXCountChars;
            public int dwYCountChars;
            public int dwFillAttribute;
            public int dwFlags;
            public int wShowWindow;
            public UNICODE_STRING WindowTitle;
            public UNICODE_STRING Desktop;
            public UNICODE_STRING ShellInfo;
            public UNICODE_STRING RuntimeInfo;
            public RTL_DRIVE_LETTER_CURDIR[] DLCurrentDirectory = new RTL_DRIVE_LETTER_CURDIR[32];

            protected List getFieldOrder() {
                return Arrays.asList("AllocationSize", "Size", "Flags", "DebugFlags", "hConsole", "ProcessGroup", "hStdInput", "hStdOutput", "hStdError", "CurrentDirectoryPath", "CurrentDirectoryHandle", "DllPath", "ImagePathName", "CommandLine", "Environment", "dwX", "dwY", "dwXSize", "dwYSize", "dwXCountChars", "dwYCountChars", "dwFillAttribute", "dwFlags", "wShowWindow", "WindowTitle", "Desktop", "ShellInfo", "RuntimeInfo", "DLCurrentDirectory");
            }
        }

        public static class PEB64
        extends Structure {
            public byte[] Reserved1 = new byte[2];
            public byte BeingDebugged;
            public byte[] Reserved2 = new byte[21];
            public Pointer Ldr;
            public Pointer ProcessParameters;
            public byte[] Reserved3 = new byte[520];
            public Pointer PostProcessInitRoutine;
            public byte[] Reserved4 = new byte[136];
            public int SessionId;

            protected List getFieldOrder() {
                return Arrays.asList("Reserved1", "BeingDebugged", "Reserved2", "Ldr", "ProcessParameters", "Reserved3", "PostProcessInitRoutine", "Reserved4", "SessionId");
            }
        }

        public static class PEB
        extends Structure {
            public byte[] Reserved1 = new byte[2];
            public byte BeingDebugged;
            public byte Reserved2;
            public Pointer[] Reserved3 = new Pointer[2];
            public Pointer Ldr;
            public Pointer ProcessParameters;
            public byte[] Reserved4 = new byte[104];
            public Pointer[] Reserved5 = new Pointer[52];
            public Pointer PostProcessInitRoutine;
            public byte[] Reserved6 = new byte[128];
            public Pointer Reserved7;
            public int SessionId;

            protected List getFieldOrder() {
                return Arrays.asList("Reserved1", "BeingDebugged", "Reserved2", "Reserved3", "Ldr", "ProcessParameters", "Reserved4", "Reserved5", "PostProcessInitRoutine", "Reserved6", "Reserved7", "SessionId");
            }
        }

        public static class PROCESS_BASIC_INFORMATION
        extends Structure {
            public Pointer Reserved1;
            public Pointer PebBaseAddress;
            public Pointer[] Reserved2 = new Pointer[2];
            public Pointer UniqueProcessId;
            public Pointer Reserved3;

            protected List getFieldOrder() {
                return Arrays.asList("Reserved1", "PebBaseAddress", "Reserved2", "UniqueProcessId", "Reserved3");
            }
        }
    }

    public static interface Shell32
    extends StdCallLibrary {
        public static final Shell32 INSTANCE = Native.loadLibrary("Shell32", Shell32.class);
        public static final int SEE_MASK_DEFAULT = 0;
        public static final int SEE_MASK_CLASSNAME = 1;
        public static final int SEE_MASK_CLASSKEY = 3;
        public static final int SEE_MASK_IDLIST = 4;
        public static final int SEE_MASK_INVOKEIDLIST = 12;
        public static final int SEE_MASK_ICON = 16;
        public static final int SEE_MASK_HOTKEY = 32;
        public static final int SEE_MASK_NOCLOSEPROCESS = 64;
        public static final int SEE_MASK_CONNECTNETDRV = 128;
        public static final int SEE_MASK_NOASYNC = 256;
        public static final int SEE_MASK_FLAG_DDEWAIT = 256;
        public static final int SEE_MASK_DOENVSUBST = 512;
        public static final int SEE_MASK_FLAG_NO_UI = 1024;
        public static final int SEE_MASK_UNICODE = 16384;
        public static final int SEE_MASK_NO_CONSOLE = 32768;
        public static final int SEE_MASK_ASYNCOK = 0x100000;
        public static final int SEE_MASK_NOQUERYCLASSSTORE = 0x1000000;
        public static final int SEE_MASK_HMONITOR = 0x200000;
        public static final int SEE_MASK_NOZONECHECKS = 0x800000;
        public static final int SEE_MASK_WAITFORINPUTIDLE = 0x2000000;
        public static final int SEE_MASK_FLAG_LOG_USAGE = 0x4000000;
        public static final String VERB_EDIT = "edit";
        public static final String VERB_EXPLORE = "explore";
        public static final String VERB_FIND = "find";
        public static final String VERB_OPEN = "open";
        public static final String VERB_PRINT = "print";
        public static final String VERB_PROPERTIES = "properties";
        public static final String VERB_RUNAS = "runas";
        public static final int SW_HIDE = 0;
        public static final int SW_MAXIMIZE = 3;
        public static final int SW_MINIMIZE = 6;
        public static final int SW_RESTORE = 9;
        public static final int SW_SHOW = 5;
        public static final int SW_SHOWDEFAULT = 10;
        public static final int SW_SHOWMAXIMIZED = 3;
        public static final int SW_SHOWMINIMIZED = 2;
        public static final int SW_SHOWMINNOACTIVE = 7;
        public static final int SW_SHOWNA = 8;
        public static final int SW_SHOWNOACTIVATE = 4;
        public static final int SW_SHOWNORMAL = 1;

        public boolean ShellExecuteEx(SHELLEXECUTEINFO var1);

        public static class SHELLEXECUTEINFO
        extends Structure {
            public int cbSize;
            public int fMask;
            public Pointer hwnd;
            public String lpVerb;
            public String lpFile;
            public String lpParameters;
            public String lpDirectory;
            public int nShow;
            public IntByReference hInstApp;
            public Pointer lpIDList;
            public String lpClass;
            public Pointer hkeyClass;
            public int dwHotKey;
            public Pointer hMonitor;
            public WinNT.HANDLE hProcess;

            protected List getFieldOrder() {
                return Arrays.asList("cbSize", "fMask", "hwnd", "lpVerb", "lpFile", "lpParameters", "lpDirectory", "nShow", "hInstApp", "lpIDList", "lpClass", "hkeyClass", "dwHotKey", "hMonitor", "hProcess");
            }
        }
    }

    public static interface Secur32
    extends StdCallLibrary {
        public static final Secur32 INSTANCE = Native.loadLibrary("Secur32", Secur32.class);

        public boolean GetUserNameEx(int var1, Memory var2, IntByReference var3);
    }
}

