/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.FastFrequencySketch$;
import org.apache.pekko.util.FrequencySketch$Bits$;
import org.apache.pekko.util.FrequencySketchUtil$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-xA\u0002\u00180\u0011\u0003\ttG\u0002\u0004:_!\u0005\u0011G\u000f\u0005\u0006\u0003\u0006!\ta\u0011\u0005\u0006\t\u0006!\t!\u0012\u0005\n\u0003\u0007\f\u0011\u0013!C\u0001\u0003\u000bD\u0011\"!8\u0002#\u0003%\t!a8\u0007\u000bez#!\r%\t\u0011)3!\u0011!Q\u0001\n-C\u0001B\u0014\u0004\u0003\u0002\u0003\u0006Ia\u0013\u0005\u0006\u0003\u001a!\ta\u0014\u0005\b=\u001a\u0011\r\u0011\"\u0004`\u0011\u0019\u0011g\u0001)A\u0007A\"91M\u0002b\u0001\n\u001by\u0006B\u00023\u0007A\u00035\u0001\rC\u0004f\r\t\u0007IQ\u00024\t\r%4\u0001\u0015!\u0004h\u0011\u001dQgA1A\u0005\u000e-DaA\u001c\u0004!\u0002\u001ba\u0007bB8\u0007\u0005\u0004%i\u0001\u001d\u0005\u0007g\u001a\u0001\u000bQB9\t\u000fQ4!\u0019!C\u0007k\"1\u0001P\u0002Q\u0001\u000eYDq!\u001f\u0004C\u0002\u00135!\u0010\u0003\u0004~\r\u0001\u0006ia\u001f\u0005\b}\u001a\u0011\r\u0011\"\u0004\u0000\u0011!\t)A\u0002Q\u0001\u000e\u0005\u0005\u0001\"CA\u0004\r\t\u0007IQBA\u0005\u0011!\tyA\u0002Q\u0001\u000e\u0005-\u0001\"CA\t\r\t\u0007IQBA\n\u0011!\tIB\u0002Q\u0001\u000e\u0005U\u0001\"CA\u000e\r\t\u0007IQBA\u000f\u0011!\t\u0019C\u0002Q\u0001\u000e\u0005}\u0001bBA\u0013\r\u0001\u0006Ia\u0013\u0005\b\u0003O1\u0001\u0015!\u0003L\u0011!\tIC\u0002Q\u0001\n\u0005-\u0002\u0002CA\u001d\r\u0001\u0006I!a\u000f\t\u000f\u0005ub\u0001)Q\u0005\u0017\"9\u0011q\b\u0004\u0005\u0002\u0005\u0005\u0003bBA\"\r\u0011\u0005\u0011Q\t\u0005\b\u0003\u00172A\u0011AA'\u0011\u001d\t9F\u0002C\u0005\u00033Bq!a\u0018\u0007\t\u0013\t\t\u0007C\u0004\u0002j\u0019!I!a\u001b\t\u000f\u0005Md\u0001\"\u0003\u0002v!9\u0011\u0011\u0011\u0004\u0005\n\u0005\r\u0005bBAC\r\u0011\u0005\u0011qQ\u0001\u0014\r\u0006\u001cHO\u0012:fcV,gnY=TW\u0016$8\r\u001b\u0006\u0003aE\nA!\u001e;jY*\u0011!gM\u0001\u0006a\u0016\\7n\u001c\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014x\r\u0005\u00029\u00035\tqFA\nGCN$hI]3rk\u0016t7-_*lKR\u001c\u0007n\u0005\u0002\u0002wA\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002o\u0005)\u0011\r\u001d9msV\u0019a)a,\u0015\u000f\u001d\u000b\t,!.\u0002:B!\u0001HBAW+\tI5k\u0005\u0002\u0007w\u0005)q/\u001b3uQB\u0011A\bT\u0005\u0003\u001bv\u00121!\u00138u\u0003%\u0011Xm]3u'&TX\rF\u0002Q9v\u00032\u0001\u000f\u0004R!\t\u00116\u000b\u0004\u0001\u0005\u000bQ3!\u0019A+\u0003\u0003\u0005\u000b\"AV-\u0011\u0005q:\u0016B\u0001->\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0010.\n\u0005mk$aA!os\")!*\u0003a\u0001\u0017\")a*\u0003a\u0001\u0017\u0006)A)\u001a9uQV\t\u0001mD\u0001b;\u0005!\u0011A\u0002#faRD\u0007%A\u0005TY>$8\u000b[5gi\u0006Q1\u000b\\8u'\"Lg\r\u001e\u0011\u0002\u0011Mcw\u000e^'bg.,\u0012aZ\b\u0002Qv\tq\"A\u0005TY>$X*Y:lA\u0005a1i\\;oi\u0016\u00148\u000b[5giV\tAnD\u0001n;\u0005\u0011\u0011!D\"pk:$XM]*iS\u001a$\b%A\u0006D_VtG/\u001a:NCN\\W#A9\u0010\u0003It\u0012aD\u0001\r\u0007>,h\u000e^3s\u001b\u0006\u001c8\u000eI\u0001\b\u001f\u0012$W*Y:l+\u00051x\"A<\u001f\u0011E\t\u0012#E\t\u0012#E\t\u0001b\u00143e\u001b\u0006\u001c8\u000eI\u0001\n%\u0016\u001cX\r^'bg.,\u0012a_\b\u0002yzAqo^<xo^<x/\u0001\u0006SKN,G/T1tW\u0002\nQaU3fIB*\"!!\u0001\u0010\u0005\u0005\ra\u0004Cb&\u0012t;::M\u0014\u0002\rM+W\r\u001a\u0019!\u0003\u0015\u0019V-\u001a32+\t\tYa\u0004\u0002\u0002\u000eyAAW%\\p}c\u0015@/\u0001\u0004TK\u0016$\u0017\u0007I\u0001\u0006'\u0016,GMM\u000b\u0003\u0003+y!!a\u0006\u001f\u0011i\r/nO\u0018\u0011\u0002>\u000baaU3fIJ\u0002\u0013!B*fK\u0012\u001cTCAA\u0010\u001f\t\t\tC\b\u0005Lft%OQI\u0012&\u0003\u0019\u0019V-\u001a34A\u0005A!o\\<XS\u0012$\b.A\u0005j]\u0012,\u00070T1tW\u00061Q.\u0019;sSb\u0004R\u0001PA\u0017\u0003cI1!a\f>\u0005\u0015\t%O]1z!\u0015a\u0014QFA\u001a!\ra\u0014QG\u0005\u0004\u0003oi$\u0001\u0002'p]\u001e\f\u0001B]8x'&TXm\u001d\t\u0005y\u000552*A\u0006va\u0012\fG/\u001a3TSj,\u0017\u0001B:ju\u0016,\u0012aS\u0001\nMJ,\u0017/^3oGf$2aSA$\u0011\u0019\tIE\na\u0001#\u0006)a/\u00197vK\u0006I\u0011N\\2sK6,g\u000e\u001e\u000b\u0005\u0003\u001f\n)\u0006E\u0002=\u0003#J1!a\u0015>\u0005\u0011)f.\u001b;\t\r\u0005%s\u00051\u0001R\u0003\u0019\u0011X\r[1tQR\u00191*a\u0017\t\r\u0005u\u0003\u00061\u0001L\u0003\u0011A\u0017m\u001d5\u0002\u000b%tG-\u001a=\u0015\u000b-\u000b\u0019'!\u001a\t\r\u0005u\u0013\u00061\u0001L\u0011\u001d\t9'\u000ba\u0001\u0003g\tAa]3fI\u0006Qq-\u001a;D_VtG/\u001a:\u0015\u000b-\u000bi'!\u001d\t\r\u0005=$\u00061\u0001L\u0003\r\u0011xn\u001e\u0005\u0007\u0003?R\u0003\u0019A&\u0002!%t7M]3nK:$8i\\;oi\u0016\u0014HCBA<\u0003{\ny\bE\u0002=\u0003sJ1!a\u001f>\u0005\u001d\u0011un\u001c7fC:Da!a\u001c,\u0001\u0004Y\u0005BBA0W\u0001\u00071*A\u0003sKN,G\u000f\u0006\u0002\u0002P\u0005iAo\u001c#fEV<7\u000b\u001e:j]\u001e,\"!!#\u0011\t\u0005-\u0015\u0011\u0014\b\u0005\u0003\u001b\u000b)\nE\u0002\u0002\u0010vj!!!%\u000b\u0007\u0005M%)\u0001\u0004=e>|GOP\u0005\u0004\u0003/k\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0006u%AB*ue&twMC\u0002\u0002\u0018vB3ABAQ!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0016Q\u0015\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eE\u0002S\u0003_#Q\u0001V\u0002C\u0002UCa!a-\u0004\u0001\u0004Y\u0015\u0001C2ba\u0006\u001c\u0017\u000e^=\t\u0011\u0005]6\u0001%AA\u0002-\u000bqb^5ei\"lU\u000f\u001c;ja2LWM\u001d\u0005\n\u0003w\u001b\u0001\u0013!a\u0001\u0003{\u000bqB]3tKRlU\u000f\u001c;ja2LWM\u001d\t\u0004y\u0005}\u0016bAAa{\t1Ai\\;cY\u0016\fq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0005\u0003\u000f\fY.\u0006\u0002\u0002J*\u001a1*a3,\u0005\u00055\u0007\u0003BAh\u0003/l!!!5\u000b\t\u0005M\u0017Q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a*>\u0013\u0011\tI.!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003U\t\t\u0007Q+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\t\t/!:\u0016\u0005\u0005\r(\u0006BA_\u0003\u0017$Q\u0001V\u0003C\u0002UC3!AAQQ\r\u0001\u0011\u0011\u0015")
@InternalApi
public final class FastFrequencySketch<A> {
    private final int resetSize;
    private final int rowWidth;
    private final int indexMask;
    private final long[][] matrix;
    private final int[] rowSizes;
    private int updatedSize;

    public static <A> double apply$default$3() {
        return FastFrequencySketch$.MODULE$.apply$default$3();
    }

    public static <A> int apply$default$2() {
        return FastFrequencySketch$.MODULE$.apply$default$2();
    }

    public static <A> FastFrequencySketch<A> apply(int capacity, int widthMultiplier, double resetMultiplier) {
        return FastFrequencySketch$.MODULE$.apply(capacity, widthMultiplier, resetMultiplier);
    }

    private final int Depth() {
        return 4;
    }

    private final int SlotShift() {
        return 4;
    }

    private final int SlotMask() {
        return 15;
    }

    private final int CounterShift() {
        return 2;
    }

    private final long CounterMask() {
        return 15L;
    }

    private final long OddMask() {
        return 0x1111111111111111L;
    }

    private final long ResetMask() {
        return 0x7777777777777777L;
    }

    private final long Seed0() {
        return -4348849565147123417L;
    }

    private final long Seed1() {
        return -5435081209227447693L;
    }

    private final long Seed2() {
        return -7286425919675154353L;
    }

    private final long Seed3() {
        return -3750763034362895579L;
    }

    public int size() {
        return this.updatedSize;
    }

    public int frequency(A value) {
        int hash = this.rehash(value.hashCode());
        int minCount = this.getCounter(0, this.index(hash, -4348849565147123417L));
        minCount = Math.min(minCount, this.getCounter(1, this.index(hash, -5435081209227447693L)));
        minCount = Math.min(minCount, this.getCounter(2, this.index(hash, -7286425919675154353L)));
        minCount = Math.min(minCount, this.getCounter(3, this.index(hash, -3750763034362895579L)));
        return minCount;
    }

    public void increment(A value) {
        int hash = this.rehash(value.hashCode());
        boolean updated = this.incrementCounter(0, this.index(hash, -4348849565147123417L));
        updated |= this.incrementCounter(1, this.index(hash, -5435081209227447693L));
        updated |= this.incrementCounter(2, this.index(hash, -7286425919675154353L));
        if (updated |= this.incrementCounter(3, this.index(hash, -3750763034362895579L))) {
            ++this.updatedSize;
            if (this.updatedSize == this.resetSize) {
                this.reset();
                return;
            }
            return;
        }
    }

    private int rehash(int hash) {
        int x = hash;
        x = (x >>> 15 ^ x) * -781669715;
        x = (x >>> 15 ^ x) * -1351469673;
        return x >>> 15 ^ x;
    }

    private int index(int hash, long seed) {
        long x = ((long)hash + seed) * seed;
        return (int)(x + (x >>> 32)) & this.indexMask;
    }

    private int getCounter(int row, int index) {
        int column = index >>> 4;
        int slot = (index & 0xF) << 2;
        return (int)(this.matrix[row][column] >>> slot & 0xFL);
    }

    private boolean incrementCounter(int row, int index) {
        int column = index >>> 4;
        int slot = (index & 0xF) << 2;
        long mask = 15L << slot;
        if ((this.matrix[row][column] & mask) != mask) {
            long[] lArray = this.matrix[row];
            lArray[column] = lArray[column] + (1L << slot);
            this.rowSizes[row] = this.rowSizes[row] + 1;
            return true;
        }
        return false;
    }

    private void reset() {
        for (int row = 0; row < 4; ++row) {
            int odd = 0;
            for (int column = 0; column < this.rowWidth; ++column) {
                odd += Long.bitCount(this.matrix[row][column] & 0x1111111111111111L);
                this.matrix[row][column] = this.matrix[row][column] >>> 1 & 0x7777777777777777L;
            }
            this.rowSizes[row] = this.rowSizes[row] - odd >>> 1;
        }
        this.updatedSize = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(this.rowSizes).max((Ordering)Ordering.Int$.MODULE$));
    }

    public String toDebugString() {
        return FrequencySketchUtil$.MODULE$.debugString(this.matrix, this.rowWidth, 16, 4, 15L);
    }

    public FastFrequencySketch(int width, int resetSize) {
        this.resetSize = resetSize;
        Predef$.MODULE$.require(FrequencySketch$Bits$.MODULE$.isPowerOfTwo(width), (Function0 & Serializable)() -> "width must be a power of two");
        this.rowWidth = package$.MODULE$.max(1, width >>> 4);
        this.indexMask = width - 1;
        this.matrix = (long[][])Array$.MODULE$.fill(4, (Function0 & Serializable)() -> (long[])Array$.MODULE$.ofDim($this.rowWidth, (ClassTag)ClassTag$.MODULE$.Long()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        this.rowSizes = (int[])Array$.MODULE$.ofDim(4, (ClassTag)ClassTag$.MODULE$.Int());
        this.updatedSize = 0;
    }
}

