/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.HibernateException;
import org.hibernate.query.BindableType;
import org.hibernate.query.criteria.JpaParameterExpression;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;

public interface SqmParameter<T>
extends SqmExpression<T>,
JpaParameterExpression<T>,
Comparable<SqmParameter<T>> {
    public String getName();

    public Integer getPosition();

    public boolean allowMultiValuedBinding();

    public BindableType<T> getAnticipatedType();

    @Override
    public SqmExpressible<T> getNodeType();

    public SqmParameter<T> copy();

    @Override
    public SqmParameter<T> copy(SqmCopyContext var1);

    @Override
    default public int compareTo(SqmParameter<T> anotherParameter) {
        if (this instanceof SqmNamedParameter) {
            SqmNamedParameter one = (SqmNamedParameter)this;
            return anotherParameter instanceof SqmNamedParameter ? one.getName().compareTo(anotherParameter.getName()) : -1;
        }
        if (this instanceof SqmPositionalParameter) {
            SqmPositionalParameter one = (SqmPositionalParameter)this;
            return anotherParameter instanceof SqmPositionalParameter ? one.getPosition().compareTo(anotherParameter.getPosition()) : 1;
        }
        if (this instanceof SqmJpaCriteriaParameterWrapper && anotherParameter instanceof SqmJpaCriteriaParameterWrapper) {
            return Integer.compare(this.hashCode(), anotherParameter.hashCode());
        }
        throw new HibernateException("Unexpected SqmParameter type for comparison : " + this + " & " + anotherParameter);
    }
}

