/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterBoolean;
import org.hibernate.type.spi.TypeConfiguration;

public class BooleanJdbcType
implements AdjustableJdbcType {
    public static final BooleanJdbcType INSTANCE = new BooleanJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 16;
    }

    @Override
    public String getFriendlyName() {
        return "BOOLEAN";
    }

    public String toString() {
        return "BooleanTypeDescriptor";
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Boolean.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterBoolean<T>(javaType);
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        int preferredSqlTypeCodeForBoolean = indicators.getPreferredSqlTypeCodeForBoolean();
        if (preferredSqlTypeCodeForBoolean != -7 && preferredSqlTypeCodeForBoolean != 16) {
            return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(preferredSqlTypeCodeForBoolean);
        }
        return this;
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return Boolean.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, options.getPreferredSqlTypeCodeForBoolean());
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, options.getPreferredSqlTypeCodeForBoolean());
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setBoolean(index, javaType.unwrap(value, Boolean.class, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setBoolean(name, (boolean)javaType.unwrap(value, Boolean.class, options));
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaType.wrap(rs.getBoolean(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getBoolean(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getBoolean(name), options);
            }
        };
    }
}

