/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.task.serdes.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class UnmodifiableCollectionsSerializer
extends Serializer<Object> {
    public Object read(Kryo kryo, Input input, Class<? extends Object> clazz) {
        int ordinal = input.readInt(true);
        UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.values()[ordinal];
        Object sourceCollection = kryo.readClassAndObject(input);
        return unmodifiableCollection.create(sourceCollection);
    }

    public void write(Kryo kryo, Output output, Object object) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(object.getClass());
            output.writeInt(unmodifiableCollection.ordinal(), true);
            kryo.writeClassAndObject(output, this.getValues(object));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object copy(Kryo kryo, Object original) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(original.getClass());
            Object sourceCollectionCopy = kryo.copy(this.getValues(original));
            return unmodifiableCollection.create(sourceCollectionCopy);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<?> getValues(Object coll) {
        return new ArrayList((Collection)coll);
    }

    public static void registerSerializers(Kryo kryo) {
        UnmodifiableCollectionsSerializer serializer = new UnmodifiableCollectionsSerializer();
        UnmodifiableCollection.values();
        for (UnmodifiableCollection item : UnmodifiableCollection.values()) {
            kryo.register(item.type, (Serializer)serializer);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum UnmodifiableCollection {
        COLLECTION((Class)Collections.unmodifiableCollection(Arrays.asList("")).getClass()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableCollection((Collection)sourceCollection);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.unmodifiableList(new ArrayList<E>()).getClass()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        LIST((Class)Collections.unmodifiableList(new LinkedList<E>()).getClass()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        SET((Class)Collections.unmodifiableSet(new HashSet<E>()).getClass()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSet((Set)sourceCollection);
            }
        }
        ,
        SORTED_SET((Class)Collections.unmodifiableSortedSet(new TreeSet<E>()).getClass()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedSet((SortedSet)sourceCollection);
            }
        }
        ,
        MAP((Class)Collections.unmodifiableMap(new HashMap<K, V>()).getClass()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableMap((Map)sourceCollection);
            }
        }
        ,
        SORTED_MAP((Class)Collections.unmodifiableSortedMap(new TreeMap<K, V>()).getClass()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedMap((SortedMap)sourceCollection);
            }
        };

        private Class<?> type;

        private UnmodifiableCollection(Class<?> type) {
            this.type = type;
        }

        public abstract Object create(Object var1);

        static UnmodifiableCollection valueOfType(Class<?> type) {
            for (UnmodifiableCollection item : UnmodifiableCollection.values()) {
                if (!item.type.equals(type)) continue;
                return item;
            }
            throw new IllegalArgumentException("The type " + type + " is not supported.");
        }
    }
}

