/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsClientBuilderConfigurer;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class AwsS3EnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsS3EnvironmentRepository, AwsS3EnvironmentProperties> {
    private final ConfigServerProperties server;

    public AwsS3EnvironmentRepositoryFactory(ConfigServerProperties server) {
        this.server = server;
    }

    @Override
    public AwsS3EnvironmentRepository build(AwsS3EnvironmentProperties environmentProperties) {
        S3ClientBuilder clientBuilder = S3Client.builder();
        AwsClientBuilderConfigurer.configureClientBuilder(clientBuilder, environmentProperties.getRegion(), environmentProperties.getEndpoint());
        S3Client client = (S3Client)clientBuilder.build();
        AwsS3EnvironmentRepository repository = new AwsS3EnvironmentRepository(client, environmentProperties.getBucket(), this.server);
        repository.setOrder(environmentProperties.getOrder());
        return repository;
    }
}

