/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.lang.reflect.Method;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class Nfsstat
extends SigarCommandBase {
    public Nfsstat(Shell shell) {
        super(shell);
    }

    public Nfsstat() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getUsageShort() {
        return "Display nfs stats";
    }

    private String getValue(Object obj, String attr) {
        if (attr == "") {
            return "";
        }
        String name = "get" + Character.toUpperCase(attr.charAt(0)) + attr.substring(1);
        try {
            Method method = obj.getClass().getMethod(name, new Class[0]);
            return method.invoke(obj, new Object[0]).toString();
        }
        catch (Exception e) {
            return "EINVAL";
        }
    }

    private void printnfs(Object nfs, String[] names) {
        Object[] values = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = this.getValue(nfs, names[i]);
        }
        this.printf(names);
        this.printf(values);
    }

    private void outputNfsV2(String header, Object nfs) {
        this.println(header + ":");
        this.printnfs(nfs, new String[]{"null", "getattr", "setattr", "root", "lookup", "readlink"});
        this.printnfs(nfs, new String[]{"read", "writecache", "write", "create", "remove", "rename"});
        this.printnfs(nfs, new String[]{"link", "symlink", "mkdir", "rmdir", "readdir", "fsstat"});
        this.println("");
        this.flush();
    }

    private void outputNfsV3(String header, Object nfs) {
        this.println(header + ":");
        this.printnfs(nfs, new String[]{"null", "getattr", "setattr", "lookup", "access", "readlink"});
        this.printnfs(nfs, new String[]{"read", "write", "create", "mkdir", "symlink", "mknod"});
        this.printnfs(nfs, new String[]{"remove", "rmdir", "rename", "link", "readdir", "readdirplus"});
        this.printnfs(nfs, new String[]{"fsstat", "fsinfo", "pathconf", "commit", "", ""});
        this.println("");
        this.flush();
    }

    public void output(String[] args) throws SigarException {
        try {
            this.outputNfsV2("Client nfs v2", this.sigar.getNfsClientV2());
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this.outputNfsV2("Server nfs v2", this.sigar.getNfsServerV2());
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this.outputNfsV3("Client nfs v3", this.sigar.getNfsClientV3());
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this.outputNfsV3("Server nfs v3", this.sigar.getNfsServerV3());
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
    }
}

