/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.errors;

import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.errors.ErrorConsumer;

public class ErrorLogReader {
    public static boolean hasErrors(AtomicBuffer buffer) {
        return buffer.capacity() >= 4 && 0 != buffer.getIntVolatile(0);
    }

    public static int read(AtomicBuffer buffer, ErrorConsumer consumer) {
        return ErrorLogReader.read(buffer, consumer, 0L);
    }

    public static int read(AtomicBuffer buffer, ErrorConsumer consumer, long sinceTimestamp) {
        int length;
        int entries = 0;
        int capacity = buffer.capacity();
        for (int offset = 0; offset < capacity && 0 != (length = buffer.getIntVolatile(offset + 0)); offset += BitUtil.align(length, 8)) {
            long lastObservationTimestamp = buffer.getLongVolatile(offset + 8);
            if (lastObservationTimestamp < sinceTimestamp) continue;
            ++entries;
            consumer.accept(buffer.getInt(offset + 4), buffer.getLong(offset + 16), lastObservationTimestamp, buffer.getStringWithoutLengthUtf8(offset + 24, length - 24));
        }
        return entries;
    }
}

