/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.factories.threads.BlockingThreadFactory;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.factories.threads.NonBlockingThreadFactory;

class ThreadFactoryConfiguration {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    static final AttributeDefinition<String> GROUP = AttributeDefinition.builder((String)"groupName", null, String.class).build();
    static final AttributeDefinition<String> THREAD_NAME_PATTERN = AttributeDefinition.builder((String)"threadNamePattern", null, String.class).build();
    static final AttributeDefinition<Integer> PRIORITY = AttributeDefinition.builder((String)"priority", null, Integer.class).build();
    private final AttributeSet attributes;
    private final Attribute<String> name;
    private final Attribute<String> groupName;
    private final Attribute<String> threadNamePattern;
    private final Attribute<Integer> priority;
    private String nodeName;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ThreadFactoryConfiguration.class, new AttributeDefinition[]{NAME, GROUP, THREAD_NAME_PATTERN, PRIORITY});
    }

    ThreadFactoryConfiguration(AttributeSet attributes, String nodeName) {
        this.attributes = attributes.checkProtection();
        this.name = attributes.attribute(NAME);
        this.groupName = attributes.attribute(GROUP);
        this.threadNamePattern = attributes.attribute(THREAD_NAME_PATTERN);
        this.priority = attributes.attribute(PRIORITY);
        this.nodeName = nodeName;
    }

    public DefaultThreadFactory getThreadFactory(boolean isNonBlocking) {
        if (isNonBlocking) {
            return new NonBlockingThreadFactory((String)this.name.get(), (String)this.groupName.get(), (int)((Integer)this.priority.get()), (String)this.threadNamePattern.get(), this.nodeName, null);
        }
        return new BlockingThreadFactory((String)this.name.get(), (String)this.groupName.get(), (int)((Integer)this.priority.get()), (String)this.threadNamePattern.get(), this.nodeName, null);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public Attribute<String> name() {
        return this.name;
    }

    public Attribute<String> groupName() {
        return this.groupName;
    }

    public Attribute<String> threadPattern() {
        return this.threadNamePattern;
    }

    public Attribute<Integer> priority() {
        return this.priority;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String toString() {
        return "ThreadFactoryConfiguration{attributes=" + this.attributes + ", nodeName='" + this.nodeName + "'}";
    }
}

