/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecificationHelper;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiDeltaSpecification
implements DeltaSpecificationWithDependencies {
    private final List<List<DeltaSpecification>> deltaSpecifications;
    private final DeployedApplication mainApplication;

    public MultiDeltaSpecification(DeltaSpecification deltaSpecification) {
        this(deltaSpecification, Collections.emptyList());
    }

    private MultiDeltaSpecification(DeltaSpecification mainDeltaSpecification, List<List<DeltaSpecification>> dependencies) {
        Checks.checkNotNull((Object)mainDeltaSpecification, (String)"Wrong usage of internal API: mainDeltaSpecification must not be null");
        this.deltaSpecifications = dependencies.stream().map(ArrayList::new).collect(Collectors.toList());
        ArrayList<DeltaSpecification> emptyList = new ArrayList<DeltaSpecification>();
        emptyList.add(mainDeltaSpecification);
        this.deltaSpecifications.add(emptyList);
        this.mainApplication = mainDeltaSpecification.getDeployedApplication();
    }

    public MultiDeltaSpecification(List<List<DeltaSpecification>> allDeltaSpecifications, DeployedApplication mainApplication) {
        Checks.checkArgument((!allDeltaSpecifications.isEmpty() ? 1 : 0) != 0, (String)"Wrong usage of internal API: allDeltaSpecifications must contain 1 element", (Object[])new Object[0]);
        this.deltaSpecifications = allDeltaSpecifications;
        this.mainApplication = mainApplication;
    }

    private Stream<List<DeltaSpecification>> deltaSpecificationStream() {
        return this.deltaSpecifications.stream();
    }

    public List<DeltaSpecification> getAllDeltaSpecifications() {
        return this.flattenDeltaSpecs();
    }

    private List<DeltaSpecification> flattenDeltaSpecs() {
        ArrayList<DeltaSpecification> deltaSpecs = new ArrayList<DeltaSpecification>();
        this.deltaSpecificationStream().forEach(deltaSpecs::addAll);
        return deltaSpecs;
    }

    public List<List<DeltaSpecification>> getAllGroupedDeltaSpecifications() {
        return this.deltaSpecifications;
    }

    public List<DeployedApplication> getAllDeployedApplications() {
        return this.flattenDeltaSpecs().stream().map(MultiDeltaSpecificationHelper::correctDeployedApplication).collect(Collectors.toList());
    }

    public List<Delta> getAllDeltas() {
        return this.flattenDeltaSpecs().stream().flatMap(spec -> spec.getDeltas().stream()).collect(Collectors.toList());
    }

    public List<String> getOrchestrators() {
        return Collections.unmodifiableList(this.mainApplication.getOrchestrator());
    }

    public DeployedApplication getMainApplication() {
        return this.mainApplication;
    }

    public static MultiDeltaSpecification withDependencies(DeltaSpecification main, List<List<DeltaSpecification>> dependencies) {
        return new MultiDeltaSpecification(main, dependencies);
    }

    public static MultiDeltaSpecification forRollback(List<List<DeltaSpecification>> deltaSpecifications, DeployedApplication mainApplication) {
        return new MultiDeltaSpecification(deltaSpecifications, mainApplication);
    }

    public static MultiDeltaSpecification forUndeploy(List<List<DeltaSpecification>> deltaSpecifications, DeployedApplication mainApplication) {
        return new MultiDeltaSpecification(deltaSpecifications, mainApplication);
    }
}

