/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.Version;
import org.hibernate.bytecode.internal.BytecodeProviderInitiator;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.cfg.AvailableSettings;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;

@Internal
public final class Environment
implements AvailableSettings {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Environment.class.getName());
    private static final boolean ENABLE_REFLECTION_OPTIMIZER;
    private static final Properties GLOBAL_PROPERTIES;
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_BYTEBUDDY = "bytebuddy";
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_NONE = "none";
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_DEFAULT = "bytebuddy";

    @Deprecated
    public static boolean useReflectionOptimizer() {
        return ENABLE_REFLECTION_OPTIMIZER;
    }

    private Environment() {
    }

    public static Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)GLOBAL_PROPERTIES);
        return copy;
    }

    @Deprecated(forRemoval=true)
    public static BytecodeProvider buildBytecodeProvider(Properties properties) {
        String provider = ConfigurationHelper.getString("hibernate.bytecode.provider", (Map)properties, "bytebuddy");
        return BytecodeProviderInitiator.buildBytecodeProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Version.logVersion();
        GLOBAL_PROPERTIES = new Properties();
        GLOBAL_PROPERTIES.setProperty("hibernate.bytecode.use_reflection_optimizer", Boolean.TRUE.toString());
        try {
            InputStream stream = ConfigHelper.getResourceAsStream("/hibernate.properties");
            try {
                GLOBAL_PROPERTIES.load(stream);
                LOG.propertiesLoaded(ConfigurationHelper.maskOut(GLOBAL_PROPERTIES, "hibernate.connection.password"));
            }
            catch (Exception e) {
                LOG.unableToLoadProperties();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    LOG.unableToCloseStreamError(ioe);
                }
            }
        }
        catch (HibernateException he) {
            LOG.propertiesNotFound();
        }
        try {
            Properties systemProperties;
            Properties properties = systemProperties = System.getProperties();
            synchronized (properties) {
                GLOBAL_PROPERTIES.putAll((Map<?, ?>)systemProperties);
            }
        }
        catch (SecurityException se) {
            LOG.unableToCopySystemProperties();
        }
        ENABLE_REFLECTION_OPTIMIZER = ConfigurationHelper.getBoolean("hibernate.bytecode.use_reflection_optimizer", GLOBAL_PROPERTIES);
        if (ENABLE_REFLECTION_OPTIMIZER) {
            LOG.usingReflectionOptimizer();
        } else {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSettingForRemoval("hibernate.bytecode.use_reflection_optimizer", "true");
        }
    }
}

