/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.api;

import java.util.Objects;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=4001)
public class CounterConfiguration {
    private final long initialValue;
    private final long upperBound;
    private final long lowerBound;
    private final long lifespan;
    private final int concurrencyLevel;
    private final CounterType type;
    private final Storage storage;

    @ProtoFactory
    CounterConfiguration(long initialValue, long lowerBound, long upperBound, int concurrencyLevel, CounterType type, Storage storage, long lifespan) {
        this.initialValue = initialValue;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.lifespan = lifespan;
        this.concurrencyLevel = concurrencyLevel;
        this.type = type;
        this.storage = storage;
    }

    public static Builder builder(CounterType type) {
        return new Builder(Objects.requireNonNull(type));
    }

    @ProtoField(number=1, defaultValue="0")
    public long initialValue() {
        return this.initialValue;
    }

    @ProtoField(number=3, defaultValue="0")
    public long upperBound() {
        return this.upperBound;
    }

    @ProtoField(number=2, defaultValue="0")
    public long lowerBound() {
        return this.lowerBound;
    }

    @ProtoField(value=5)
    public CounterType type() {
        return this.type;
    }

    @ProtoField(number=4, defaultValue="0")
    public int concurrencyLevel() {
        return this.concurrencyLevel;
    }

    @ProtoField(value=6)
    public Storage storage() {
        return this.storage;
    }

    @ProtoField(number=7, defaultValue="0")
    public long lifespan() {
        return this.lifespan;
    }

    public String toString() {
        return "CounterConfiguration{initialValue=" + this.initialValue + ", upperBound=" + this.upperBound + ", lowerBound=" + this.lowerBound + ", concurrencyLevel=" + this.concurrencyLevel + ", type=" + this.type + ", storage=" + this.storage + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterConfiguration that = (CounterConfiguration)o;
        return this.initialValue == that.initialValue && this.upperBound == that.upperBound && this.lowerBound == that.lowerBound && this.concurrencyLevel == that.concurrencyLevel && this.type == that.type && this.storage == that.storage;
    }

    public int hashCode() {
        int result = (int)(this.initialValue ^ this.initialValue >>> 32);
        result = 31 * result + (int)(this.upperBound ^ this.upperBound >>> 32);
        result = 31 * result + (int)(this.lowerBound ^ this.lowerBound >>> 32);
        result = 31 * result + this.concurrencyLevel;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.storage.hashCode();
        return result;
    }

    public static class Builder {
        private final CounterType type;
        private long initialValue = 0L;
        private long lowerBound = Long.MIN_VALUE;
        private long upperBound = Long.MAX_VALUE;
        private long lifespan = 0L;
        private Storage storage = Storage.VOLATILE;
        private int concurrencyLevel = 16;

        private Builder(CounterType type) {
            this.type = type;
        }

        public Builder initialValue(long initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Builder lowerBound(long lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public Builder upperBound(long upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public Builder lifespan(long lifespan) {
            this.lifespan = lifespan;
            return this;
        }

        public Builder storage(Storage storage) {
            this.storage = Objects.requireNonNull(storage);
            return this;
        }

        public Builder concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public CounterConfiguration build() {
            return new CounterConfiguration(this.initialValue, this.lowerBound, this.upperBound, this.concurrencyLevel, this.type, this.storage, this.lifespan);
        }
    }
}

