/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v2.impl;

import ai.digital.deploy.permissions.api.rest.dto.EditRolePermissionsRequest;
import ai.digital.deploy.permissions.api.rest.dto.GetGlobalPermissionsForPrincipalNameDto;
import ai.digital.deploy.permissions.api.rest.dto.GetGlobalPermissionsForRoleIdDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import jakarta.validation.Valid;
import java.util.UUID;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@RestController
@RequestMapping(value={"/v2/permissions/global"})
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\u0004\t\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006Y\u0001!\t!\f\u0005\u0006U\u0002!\ta\u001b\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\u00111%\u0012=uK:$W\rZ$m_\n\fG\u000eU3s[&\u001c8/[8og\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\n\u0015\u0005!\u0011.\u001c9m\u0015\tYA\"\u0001\u0002we)\u0011QBD\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012a\u00039fe6L7o]5p]NT!a\u0005\u000b\u0002\r\u0011,\u0007\u000f\\8z\u0015\t)b#A\u0004eS\u001eLG/\u00197\u000b\u0003]\t!!Y5\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002/\u001ddwNY1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0011\u0003\u001d\u0019XM\u001d<jG\u0016L!AJ\u0012\u0003/\u001dcwNY1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002*WA\u0011!\u0006A\u0007\u0002\u0011!)\u0001E\u0001a\u0001C\u0005yQ\rZ5u!\u0016\u0014X.[:tS>t7\u000fF\u0002/iA\u0003\"a\f\u001a\u000e\u0003AR!!\r\u0007\u0002\u0007\u0011$x.\u0003\u00024a\ta\"k\u001c7f/&$\bn\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8t\tR|\u0007\"B\u001b\u0004\u0001\u00041\u0014\u0001\u0003:pY\u0016t\u0015-\\3\u0011\u0005]rdB\u0001\u001d=!\tID$D\u0001;\u0015\tY\u0004$\u0001\u0004=e>|GOP\u0005\u0003{q\ta\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011Q\b\b\u0015\u0003i\t\u0003\"a\u0011(\u000e\u0003\u0011S!!\u0012$\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002H\u0011\u0006!!-\u001b8e\u0015\tI%*A\u0002xK\nT!a\u0013'\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!T\u0001\u0004_J<\u0017BA(E\u00051\u0001\u0016\r\u001e5WCJL\u0017M\u00197f\u0011\u0015\t6\u00011\u0001S\u0003i)G-\u001b;S_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8t%\u0016\fX/Z:u!\ty3+\u0003\u0002Ua\tQR\tZ5u%>dW\rU3s[&\u001c8/[8ogJ+\u0017/^3ti\"\u0012\u0001K\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000b!B^1mS\u0012\fG/[8o\u0015\u0005Y\u0016a\u00026bW\u0006\u0014H/Y\u0005\u0003;b\u0013QAV1mS\u0012D#\u0001U0\u0011\u0005\r\u0003\u0017BA1E\u0005-\u0011V-];fgR\u0014u\u000eZ=)\t\r\u0019gm\u001a\t\u0003\u0007\u0012L!!\u001a#\u0003\u0019A\u000bGo\u00195NCB\u0004\u0018N\\4\u0002\u000bY\fG.^3-\u0003!\f\u0013![\u0001\f_m\u0014x\u000e\\3OC6,W0A\u000fhKR<En\u001c2bYB+'/\\5tg&|gn\u001d$peJ{G.Z%e)\taW\u000fE\u0002neZr!A\u001c9\u000f\u0005ez\u0017\"A\u000f\n\u0005Ed\u0012a\u00029bG.\fw-Z\u0005\u0003gR\u0014A\u0001T5ti*\u0011\u0011\u000f\b\u0005\u0006c\u0011\u0001\rA\u001e\t\u0003_]L!\u0001\u001f\u0019\u0003A\u001d+Go\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8t\r>\u0014(k\u001c7f\u0013\u0012$Eo\u001c\u0015\u0003kZCC\u0001B>g}B\u00111\t`\u0005\u0003{\u0012\u0013!bR3u\u001b\u0006\u0004\b/\u001b8hY\u0005y\u0018EAA\u0001\u0003%y3P]8mK&#W0\u0001\u0011hKR<En\u001c2bYB+'/\\5tg&|gn\u001d$peB\u0013\u0018N\\2ja\u0006dG\u0003BA\u0004\u0003\u001b\u0001BaNA\u0005m%\u0019\u00111\u0002!\u0003\u0007M+G\u000f\u0003\u00042\u000b\u0001\u0007\u0011q\u0002\t\u0004_\u0005E\u0011bAA\na\t9s)\u001a;HY>\u0014\u0017\r\u001c)fe6L7o]5p]N4uN\u001d)sS:\u001c\u0017\u000e]1m\u001d\u0006lW\r\u0012;pQ\r\tiA\u0016\u0015\u0006\u000bm4\u0017\u0011\u0004\u0017\u0003\u00037\t#!!\b\u00025=\u0002(/\u001b8dSB\fGnL>qe&t7-\u001b9bY:\u000bW.Z?\u0002\u0013\u0011,G.\u001a;f\u00032dGCAA\u0012!\rY\u0012QE\u0005\u0004\u0003Oa\"\u0001B+oSRDcABA\u0016M\u0006E\u0002cA\"\u0002.%\u0019\u0011q\u0006#\u0003\u001b\u0011+G.\u001a;f\u001b\u0006\u0004\b/\u001b8hY\t\t\u0019$\t\u0002\u00026\u0005!q&\u00197mQ\r\u0001\u0011\u0011\b\t\u0004\u0007\u0006m\u0012bAA\u001f\t\nq!+Z:u\u0007>tGO]8mY\u0016\u0014\bF\u0002\u0001\u0002B\u0019\f9\u0005E\u0002D\u0003\u0007J1!!\u0012E\u00059\u0011V-];fgRl\u0015\r\u001d9j]\u001ed#!!\u0013\"\u0005\u0005-\u0013AF\u0018we=\u0002XM]7jgNLwN\\:0O2|'-\u00197")
public class ExtendedGlobalPermissionsController {
    private final GlobalPermissionService globalPermissionService;

    @PatchMapping(value={"/{roleName}"})
    public RoleWithGlobalPermissionsDto editPermissions(@PathVariable String roleName, @Valid @RequestBody EditRolePermissionsRequest editRolePermissionsRequest) {
        Right right;
        Tuple2 tuple2;
        Either either = this.globalPermissionService.edit(roleName, CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.addedPermissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.removedPermissions()).asScala().toList());
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            Role role = (Role)tuple2._1();
            List permissions = (List)tuple2._2();
            return new RoleWithGlobalPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto(permissions));
        }
        throw new MatchError((Object)either);
    }

    @GetMapping(value={"/{roleId}"})
    public List<String> getGlobalPermissionsForRoleId(@Valid GetGlobalPermissionsForRoleIdDto dto) {
        return this.globalPermissionService.getGlobalPermissionsForRoleId(UUID.fromString(dto.roleId()));
    }

    @GetMapping(value={"/principal/{principalName}"})
    public Set<String> getGlobalPermissionsForPrincipal(@Valid GetGlobalPermissionsForPrincipalNameDto dto) {
        return this.globalPermissionService.getGlobalPermissionsForPrincipal(dto.principalName());
    }

    @DeleteMapping(value={"/all"})
    public void deleteAll() {
        this.globalPermissionService.removeAll();
    }

    public ExtendedGlobalPermissionsController(GlobalPermissionService globalPermissionService) {
        this.globalPermissionService = globalPermissionService;
    }
}

