/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import org.apache.derby.client.ClientAutoloadedDriver;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.shared.common.error.ExceptionUtil;

public class BasicClientDataSource
implements DataSource,
ClientDataSourceInterface,
Serializable {
    private static final long serialVersionUID = 1894299584216955554L;
    public static final String className__ = "org.apache.derby.client.BasicClientDataSource";
    public static final int TRACE_NONE = 0;
    public static final int TRACE_CONNECTION_CALLS = 1;
    public static final int TRACE_STATEMENT_CALLS = 2;
    public static final int TRACE_RESULT_SET_CALLS = 4;
    public static final int TRACE_DRIVER_CONFIGURATION = 16;
    public static final int TRACE_CONNECTS = 32;
    public static final int TRACE_PROTOCOL_FLOWS = 64;
    public static final int TRACE_RESULT_SET_META_DATA = 128;
    public static final int TRACE_PARAMETER_META_DATA = 256;
    public static final int TRACE_DIAGNOSTICS = 512;
    public static final int TRACE_XA_CALLS = 2048;
    public static final int TRACE_ALL = -1;
    public static final int propertyDefault_traceLevel = -1;
    public static final short USER_ONLY_SECURITY = 4;
    public static final short CLEAR_TEXT_PASSWORD_SECURITY = 3;
    public static final short ENCRYPTED_PASSWORD_SECURITY = 7;
    public static final short ENCRYPTED_USER_AND_PASSWORD_SECURITY = 9;
    public static final short STRONG_PASSWORD_SUBSTITUTE_SECURITY = 8;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private String databaseName;
    private String description;
    private String dataSourceName;
    private int portNumber = 1527;
    private String serverName = "localhost";
    public static final int SSL_OFF = 0;
    private static final String SSL_OFF_STR = "off";
    public static final int SSL_BASIC = 1;
    private static final String SSL_BASIC_STR = "basic";
    public static final int SSL_PEER_AUTHENTICATION = 2;
    private static final String SSL_PEER_AUTHENTICATION_STR = "peerAuthentication";
    private String user = "APP";
    private static final short SECMEC_HAS_NOT_EXPLICITLY_SET = 0;
    private short securityMechanism = 0;
    private boolean retrieveMessageText = true;
    private String traceFile;
    private transient int traceFileSuffixIndex_ = 0;
    private String traceDirectory;
    private boolean traceFileAppend = false;
    private String password;
    private int sslMode;
    private boolean createDatabase;
    private boolean shutdownDatabase;
    private String connectionAttributes = null;
    private int traceLevel = -1;

    @Override
    public synchronized void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public static int getSSLModeFromString(String string) throws SqlException {
        if (string != null) {
            if (string.equalsIgnoreCase(SSL_OFF_STR)) {
                return 0;
            }
            if (string.equalsIgnoreCase(SSL_BASIC_STR)) {
                return 1;
            }
            if (string.equalsIgnoreCase(SSL_PEER_AUTHENTICATION_STR)) {
                return 2;
            }
            throw new SqlException(null, new ClientMessageId("XJ05B.C"), "ssl", string, "off, basic, peerAuthentication");
        }
        return 0;
    }

    public static int getClientSSLMode(Properties properties) throws SqlException {
        return BasicClientDataSource.getSSLModeFromString(properties.getProperty("ssl"));
    }

    public static String getUser(Properties properties) {
        String string = properties.getProperty("user");
        return BasicClientDataSource.parseString(string, "APP");
    }

    public static short getSecurityMechanism(Properties properties) {
        short s;
        String string = properties.getProperty("securityMechanism");
        if (string != null) {
            s = Short.parseShort(string);
        } else {
            String string2 = properties.getProperty("password");
            s = BasicClientDataSource.getUpgradedSecurityMechanism(string2);
        }
        return s;
    }

    private static short getUpgradedSecurityMechanism(String string) {
        if (string == null) {
            return 4;
        }
        return 3;
    }

    public static boolean getRetrieveMessageText(Properties properties) {
        String string = properties.getProperty("retrieveMessageText");
        return BasicClientDataSource.parseBoolean(string, true);
    }

    public static String getTraceFile(Properties properties) {
        return properties.getProperty("traceFile");
    }

    public static String getTraceDirectory(Properties properties) {
        String string = BasicClientDataSource.readSystemProperty("derby.client.traceDirectory");
        if (string == null && properties != null) {
            return properties.getProperty("traceDirectory");
        }
        return string;
    }

    private static String readSystemProperty(String string) {
        return System.getProperty(string);
    }

    public static boolean getTraceFileAppend(Properties properties) {
        String string = properties.getProperty("traceFileAppend");
        return BasicClientDataSource.parseBoolean(string, false);
    }

    public static String getPassword(Properties properties) {
        return properties.getProperty("password");
    }

    @Override
    public synchronized void setPassword(String string) {
        this.password = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private LogWriter computeDncLogWriterForNewConnection(String string) throws SqlException {
        return BasicClientDataSource.computeDncLogWriterForNewConnection(this.logWriter, this.traceDirectory, this.traceFile, this.traceFileAppend, this.traceLevel, string, this.traceFileSuffixIndex_++);
    }

    public static LogWriter computeDncLogWriterForNewConnection(PrintWriter printWriter, String string, String string2, boolean bl, int n, String string3, int n2) throws SqlException {
        LogWriter logWriter = BasicClientDataSource.computeDncLogWriter(printWriter, string, string2, bl, string3, n2, n);
        return logWriter;
    }

    private static LogWriter computeDncLogWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n, int n2) throws SqlException {
        if (n2 == 0) {
            return null;
        }
        PrintWriter printWriter2 = BasicClientDataSource.computePrintWriter(printWriter, string, string2, bl, string3, n);
        if (printWriter2 == null) {
            return null;
        }
        NetLogWriter netLogWriter = new NetLogWriter(printWriter2, n2);
        if (printWriter2 != printWriter && (string != null || string2 != null)) {
            netLogWriter.printWriterNeedsToBeClosed_ = true;
        }
        return netLogWriter;
    }

    private static PrintWriter computePrintWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n) throws SqlException {
        if (printWriter != null) {
            return printWriter;
        }
        if (string != null) {
            String string4 = string2 == null ? string + File.separator + string3 + "_" + n : string + File.separator + string2 + string3 + "_" + n;
            return BasicClientDataSource.getPrintWriter(string4, true);
        }
        if (string2 != null) {
            return BasicClientDataSource.getPrintWriter(string2, bl);
        }
        return null;
    }

    private static PrintWriter getPrintWriter(String string, boolean bl) throws SqlException {
        PrintWriter printWriter = null;
        try {
            String string2 = new File(string).getCanonicalPath();
            printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(string2, bl), 4096), true);
        }
        catch (Exception exception) {
            throw new SqlException(null, new ClientMessageId("XJ113.S"), new Object[]{new Object[]{string, exception.getMessage()}, exception});
        }
        return printWriter;
    }

    private static boolean parseBoolean(String string, boolean bl) {
        if (string != null) {
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        return bl;
    }

    private static String parseString(String string, String string2) {
        if (string != null) {
            return string;
        }
        return string2;
    }

    private static int parseInt(String string, int n) {
        if (string != null) {
            return Integer.parseInt(string);
        }
        return n;
    }

    public static Properties tokenizeAttributes(String string, Properties properties) throws SqlException {
        if (string == null) {
            return properties;
        }
        Properties properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    throw new SqlException(null, new ClientMessageId("XJ212.S"), string);
                }
                properties2.setProperty(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, new ClientMessageId("XJ212.S"), noSuchElementException, string);
        }
        BasicClientDataSource.checkBoolean(properties2, "retrieveMessageText");
        return properties2;
    }

    private static void checkBoolean(Properties properties, String string) throws SqlException {
        String[] stringArray = new String[]{"true", "false"};
        BasicClientDataSource.checkEnumeration(properties, string, stringArray);
    }

    private static void checkEnumeration(Properties properties, String string, String[] stringArray) throws SqlException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.toUpperCase(Locale.ENGLISH).equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        Object object = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                object = (String)object + "|";
            }
            object = (String)object + stringArray[i];
        }
        throw new SqlException(null, new ClientMessageId("XJ05B.C"), string, string2, object);
    }

    @Override
    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public synchronized void setDescription(String string) {
        this.description = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setPortNumber(int n) {
        this.portNumber = n;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public synchronized void setUser(String string) {
        this.user = string;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public synchronized void setRetrieveMessageText(boolean bl) {
        this.retrieveMessageText = bl;
    }

    @Override
    public boolean getRetrieveMessageText() {
        return this.retrieveMessageText;
    }

    @Override
    public synchronized void setSecurityMechanism(short s) {
        this.securityMechanism = s;
    }

    @Override
    public short getSecurityMechanism() {
        return this.getSecurityMechanism(this.getPassword());
    }

    @Override
    public short getSecurityMechanism(String string) {
        if (this.securityMechanism == 0) {
            return BasicClientDataSource.getUpgradedSecurityMechanism(string);
        }
        return this.securityMechanism;
    }

    @Override
    public void setSsl(String string) throws SqlException {
        this.sslMode = BasicClientDataSource.getSSLModeFromString(string);
    }

    @Override
    public String getSsl() {
        switch (this.sslMode) {
            default: {
                return SSL_OFF_STR;
            }
            case 1: {
                return SSL_BASIC_STR;
            }
            case 2: 
        }
        return SSL_PEER_AUTHENTICATION_STR;
    }

    @Override
    public void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.equalsIgnoreCase("create");
    }

    @Override
    public String getCreateDatabase() {
        String string = null;
        if (this.createDatabase) {
            string = "create";
        }
        return string;
    }

    @Override
    public void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase("shutdown");
    }

    @Override
    public String getShutdownDatabase() {
        String string = null;
        if (this.shutdownDatabase) {
            string = "shutdown";
        }
        return string;
    }

    @Override
    public void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
    }

    @Override
    public String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public static int getTraceLevel(Properties properties) {
        String string = BasicClientDataSource.readSystemProperty("derby.client.traceLevel");
        if (string == null && properties != null) {
            string = properties.getProperty("traceLevel");
        }
        if (string != null) {
            return BasicClientDataSource.parseInt(string, -1);
        }
        return -1;
    }

    @Override
    public synchronized void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    @Override
    public int getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public synchronized void setTraceFile(String string) {
        this.traceFile = string;
    }

    @Override
    public String getTraceFile() {
        return this.traceFile;
    }

    @Override
    public synchronized void setTraceDirectory(String string) {
        this.traceDirectory = string;
    }

    @Override
    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    @Override
    public synchronized void setTraceFileAppend(boolean bl) {
        this.traceFileAppend = bl;
    }

    @Override
    public boolean getTraceFileAppend() {
        return this.traceFileAppend;
    }

    public int maxStatementsToPool() {
        return 0;
    }

    private void updateDataSourceValues(Properties properties) throws SqlException {
        int n;
        String string = BasicClientDataSource.getTraceDirectory(properties);
        if (string != null) {
            this.setTraceDirectory(string);
        }
        if ((n = BasicClientDataSource.getTraceLevel(properties)) != -1) {
            this.setTraceLevel(n);
        }
        if (properties == null) {
            return;
        }
        if (properties.containsKey("user")) {
            this.setUser(BasicClientDataSource.getUser(properties));
        }
        if (properties.containsKey("securityMechanism")) {
            this.setSecurityMechanism(BasicClientDataSource.getSecurityMechanism(properties));
        }
        if (properties.containsKey("traceFile")) {
            this.setTraceFile(BasicClientDataSource.getTraceFile(properties));
        }
        if (properties.containsKey("traceFileAppend")) {
            this.setTraceFileAppend(BasicClientDataSource.getTraceFileAppend(properties));
        }
        if (properties.containsKey("retrieveMessageText")) {
            this.setRetrieveMessageText(BasicClientDataSource.getRetrieveMessageText(properties));
        }
        if (properties.containsKey("ssl")) {
            this.sslMode = BasicClientDataSource.getClientSSLMode(properties);
        }
    }

    private void handleConnectionException(LogWriter logWriter, SqlException sqlException) throws SQLException {
        if (sqlException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ212.S"))) {
            throw new SqlException(logWriter, new ClientMessageId("XJ028.C"), sqlException, this.constructUrl()).getSQLException();
        }
    }

    private String constructUrl() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("jdbc:derby://");
        stringBuilder.append(this.serverName);
        stringBuilder.append(':');
        stringBuilder.append(this.portNumber);
        stringBuilder.append('/');
        stringBuilder.append(this.databaseName);
        if (this.connectionAttributes != null) {
            stringBuilder.append(';');
            stringBuilder.append(this.connectionAttributes);
        }
        return stringBuilder.toString();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_sds");
            return this.getConnectionX(logWriter, this.getUser(), this.getPassword());
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_sds");
            return this.getConnectionX(logWriter, string, string2);
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    private Connection getConnectionX(LogWriter logWriter, String string, String string2) throws SqlException {
        return ClientAutoloadedDriver.getFactory().newNetConnection(logWriter, string, string2, this, -1, false);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw SQLExceptionFactory.notImplemented("getParentLogger");
    }

    protected final PooledConnection getPooledConnectionMinion() throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry(this, "getPooledConnection", new Object[0]);
            }
            PooledConnection pooledConnection = BasicClientDataSource.getPooledConnectionX(logWriter, this, this.getUser(), this.getPassword());
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    protected final PooledConnection getPooledConnectionMinion(String string, String string2) throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry(this, "getPooledConnection", string, "<escaped>");
            }
            PooledConnection pooledConnection = BasicClientDataSource.getPooledConnectionX(logWriter, this, string, string2);
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    private static PooledConnection getPooledConnectionX(LogWriter logWriter, BasicClientDataSource basicClientDataSource, String string, String string2) throws SQLException {
        return ClientAutoloadedDriver.getFactory().newClientPooledConnection(basicClientDataSource, logWriter, string, string2);
    }

    protected final XAConnection getXAConnectionMinion() throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_xads");
            return BasicClientDataSource.getXAConnectionX(logWriter, this, this.getUser(), this.getPassword());
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    protected final XAConnection getXAConnectionMinion(String string, String string2) throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_xads");
            return BasicClientDataSource.getXAConnectionX(logWriter, this, string, string2);
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    private static XAConnection getXAConnectionX(LogWriter logWriter, BasicClientDataSource basicClientDataSource, String string, String string2) throws SQLException {
        return ClientAutoloadedDriver.getFactory().newClientXAConnection(basicClientDataSource, logWriter, string, string2);
    }

    public static Properties getProperties(BasicClientDataSource basicClientDataSource) {
        Properties properties = new Properties();
        Method[] methodArray = basicClientDataSource.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            String string;
            Method method = methodArray[i];
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || (string = method.getName()).length() < 5 || !string.startsWith("get") || !Integer.TYPE.equals(clazz = method.getReturnType()) && !Short.TYPE.equals(clazz) && !String.class.equals(clazz) && !Boolean.TYPE.equals(clazz)) continue;
            String string2 = string.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(string.substring(4));
            try {
                Object object = method.invoke((Object)basicClientDataSource, (Object[])null);
                if (object == null) continue;
                properties.setProperty(string2, object.toString());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return properties;
    }

    static {
        try {
            new EncryptionManager(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

