/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.jcache.logging.Log;

public class Expiration {
    private static final Log log = (Log)LogFactory.getLog(Expiration.class, Log.class);

    private Expiration() {
    }

    public static Duration getExpiry(ExpiryPolicy policy, Operation op) {
        if (policy == null) {
            return Expiration.getDefaultDuration();
        }
        switch (op) {
            case CREATION: {
                try {
                    return policy.getExpiryForCreation();
                }
                catch (Throwable t) {
                    log.getExpiryHasThrown(t);
                    return Expiration.getDefaultDuration();
                }
            }
            case ACCESS: {
                try {
                    return policy.getExpiryForAccess();
                }
                catch (Throwable t) {
                    log.getExpiryHasThrown(t);
                    return null;
                }
            }
            case UPDATE: {
                try {
                    return policy.getExpiryForUpdate();
                }
                catch (Throwable t) {
                    log.getExpiryHasThrown(t);
                    return null;
                }
            }
        }
        throw log.unknownExpiryOperation(op.toString());
    }

    public static Duration getDefaultDuration() {
        return Duration.ETERNAL;
    }

    public static enum Operation {
        CREATION,
        ACCESS,
        UPDATE;

    }
}

