/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.time.Duration;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.session.Session;

class HttpSessionAdapter<S extends Session>
implements HttpSession {
    private static final Log logger = LogFactory.getLog(HttpSessionAdapter.class);
    private final S session;
    private final ServletContext servletContext;
    private boolean invalidated;
    private boolean old;

    HttpSessionAdapter(S session, ServletContext servletContext) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext cannot be null");
        }
        this.session = session;
        this.servletContext = servletContext;
    }

    S getSession() {
        return this.session;
    }

    public long getCreationTime() {
        this.checkState();
        return this.session.getCreationTime().toEpochMilli();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        this.checkState();
        return this.session.getLastAccessedTime().toEpochMilli();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(Duration.ofSeconds(interval));
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMaxInactiveInterval().getSeconds();
    }

    public Object getAttribute(String name) {
        this.checkState();
        return this.session.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkState();
        return Collections.enumeration(this.session.getAttributeNames());
    }

    public void setAttribute(String name, Object value) {
        this.checkState();
        Object oldValue = this.session.getAttribute(name);
        this.session.setAttribute(name, value);
        if (value != oldValue) {
            if (oldValue instanceof HttpSessionBindingListener) {
                try {
                    ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
                }
                catch (Throwable th) {
                    logger.error((Object)"Error invoking session binding event listener", th);
                }
            }
            if (value instanceof HttpSessionBindingListener) {
                try {
                    ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
                }
                catch (Throwable th) {
                    logger.error((Object)"Error invoking session binding event listener", th);
                }
            }
        }
    }

    public void removeAttribute(String name) {
        this.checkState();
        Object oldValue = this.session.getAttribute(name);
        this.session.removeAttribute(name);
        if (oldValue instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
            }
            catch (Throwable th) {
                logger.error((Object)"Error invoking session binding event listener", th);
            }
        }
    }

    public void invalidate() {
        this.checkState();
        this.invalidated = true;
    }

    public boolean isNew() {
        this.checkState();
        return !this.old;
    }

    void markNotNew() {
        this.old = true;
    }

    private void checkState() {
        if (this.invalidated) {
            throw new IllegalStateException("The HttpSession has already be invalidated.");
        }
    }
}

