/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.PDU;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.OctetString;

public class ScopedPDU
extends PDU {
    private static final long serialVersionUID = 4343157159110407279L;
    private OctetString contextEngineID = new OctetString();
    private OctetString contextName = new OctetString();

    public ScopedPDU() {
    }

    public ScopedPDU(ScopedPDU scopedPDU) {
        super(scopedPDU);
        this.contextEngineID = (OctetString)scopedPDU.contextEngineID.clone();
        this.contextName = (OctetString)scopedPDU.contextName.clone();
    }

    public void setContextEngineID(OctetString octetString) {
        if (octetString == null) {
            throw new NullPointerException("Context engine ID must not be null");
        }
        this.contextEngineID = octetString;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public void setContextName(OctetString octetString) {
        if (octetString == null) {
            throw new NullPointerException("Context name must not be null");
        }
        this.contextName = octetString;
    }

    public OctetString getContextName() {
        return this.contextName;
    }

    public int getBERLength() {
        int n = this.getBERPayloadLength();
        n += 1 + BER.getBERLengthOfLength(n);
        return n;
    }

    public int getBERPayloadLength() {
        int n = super.getBERLength();
        int n2 = this.contextEngineID == null ? 0 : this.contextEngineID.length();
        int n3 = this.contextName == null ? 0 : this.contextName.length();
        return n += BER.getBERLengthOfLength(n2) + 1 + n2 + BER.getBERLengthOfLength(n3) + 1 + n3;
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeHeader(outputStream, 48, this.getBERPayloadLength());
        this.contextEngineID.encodeBER(outputStream);
        this.contextName.encodeBER(outputStream);
        super.encodeBER(outputStream);
    }

    public Object clone() {
        return new ScopedPDU(this);
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n = BER.decodeHeader(bERInputStream, mutableByte);
        long l = bERInputStream.getPosition();
        this.contextEngineID.decodeBER(bERInputStream);
        this.contextName.decodeBER(bERInputStream);
        super.decodeBER(bERInputStream);
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(n, (int)(bERInputStream.getPosition() - l), this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ScopedPDU.getTypeString(this.type));
        stringBuffer.append("[reqestID=");
        stringBuffer.append(this.requestID);
        stringBuffer.append(", errorStatus=");
        stringBuffer.append(this.errorStatus);
        stringBuffer.append(", errorIndex=");
        stringBuffer.append(this.errorIndex);
        stringBuffer.append(", VBS[");
        for (int i = 0; i < this.variableBindings.size(); ++i) {
            stringBuffer.append(this.variableBindings.get(i));
            if (i + 1 >= this.variableBindings.size()) continue;
            stringBuffer.append("; ");
        }
        stringBuffer.append("]]");
        return stringBuffer.toString();
    }
}

