/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.io.NotSerializableException;
import java.nio.ByteBuffer;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.Serializer;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra!B\u0006\r\u00059!\u0002\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\t\u0011-\u0002!\u0011!Q\u0001\n\u0015BQ\u0001\f\u0001\u0005\u00025BQ\u0001\r\u0001\u0005BEBq!\u000e\u0001C\u0002\u0013\u0005c\u0007\u0003\u0004;\u0001\u0001\u0006Ia\u000e\u0005\u0006w\u0001!\t\u0005\u0010\u0005\u0006\u0019\u0002!\t%\u0014\u0005\u0006w\u0001!\t\u0005\u0018\u0005\u0006\u0019\u0002!\t\u0005\u001a\u0002\u000f\u0019>twmU3sS\u0006d\u0017N_3s\u0015\tia\"A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u001fA\tQ\u0001]3lW>T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sON!\u0001!F\u000e !\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$H\u0007\u0002\u0019%\u0011a\u0004\u0004\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001\u000f!\u0013\t\tCB\u0001\u000bCsR,')\u001e4gKJ\u001cVM]5bY&TXM]\u0001\u0007gf\u001cH/Z7\u0004\u0001U\tQ\u0005\u0005\u0002'S5\tqE\u0003\u0002)\u001d\u0005)\u0011m\u0019;pe&\u0011!f\n\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q\u0011af\f\t\u00039\u0001AQAI\u0002A\u0002\u0015\nq\"\u001b8dYV$W-T1oS\u001a,7\u000f^\u000b\u0002eA\u0011acM\u0005\u0003i]\u0011qAQ8pY\u0016\fg.\u0001\u0006jI\u0016tG/\u001b4jKJ,\u0012a\u000e\t\u0003-aJ!!O\f\u0003\u0007%sG/A\u0006jI\u0016tG/\u001b4jKJ\u0004\u0013\u0001\u0003;p\u0005&t\u0017M]=\u0015\u0007u\u0002%\t\u0005\u0002\u0017}%\u0011qh\u0006\u0002\u0005+:LG\u000fC\u0003B\u000f\u0001\u0007Q#A\u0001p\u0011\u0015\u0019u\u00011\u0001E\u0003\r\u0011WO\u001a\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b1A\\5p\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\u0015\tKH/\u001a\"vM\u001a,'/\u0001\u0006ge>l')\u001b8bef$2!\u0006(P\u0011\u0015\u0019\u0005\u00021\u0001E\u0011\u0015\u0001\u0006\u00021\u0001R\u0003!i\u0017M\\5gKN$\bC\u0001*Z\u001d\t\u0019v\u000b\u0005\u0002U/5\tQK\u0003\u0002WG\u00051AH]8pizJ!\u0001W\f\u0002\rA\u0013X\rZ3g\u0013\tQ6L\u0001\u0004TiJLgn\u001a\u0006\u00031^!\"!X2\u0011\u0007Yq\u0006-\u0003\u0002`/\t)\u0011I\u001d:bsB\u0011a#Y\u0005\u0003E^\u0011AAQ=uK\")\u0011)\u0003a\u0001+Q\u0019Q#Z4\t\u000b\u0019T\u0001\u0019A/\u0002\u000b\tLH/Z:\t\u000bAS\u0001\u0019\u00015\u0011\u0007YI7.\u0003\u0002k/\t1q\n\u001d;j_:\u0004$\u0001\\9\u0011\u0007Ikw.\u0003\u0002o7\n)1\t\\1tgB\u0011\u0001/\u001d\u0007\u0001\t%\u0011x-!A\u0001\u0002\u000b\u00051OA\u0002`IE\n\"\u0001^<\u0011\u0005Y)\u0018B\u0001<\u0018\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0006=\n\u0005e<\"aA!os\"\u0012\u0001a\u001f\t\u0003y~l\u0011! \u0006\u0003}:\t!\"\u00198o_R\fG/[8o\u0013\r\t\t! \u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public final class LongSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        buf.putLong(BoxesRunTime.unboxToLong((Object)o));
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return BoxesRunTime.boxToLong((long)buf.getLong());
    }

    @Override
    public byte[] toBinary(Object o) {
        byte[] result = new byte[8];
        int i = 0;
        for (long j = BoxesRunTime.unboxToLong((Object)o); j != 0L; j >>>= 8) {
            result[i] = (byte)(j & 0xFFL);
            ++i;
        }
        return result;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            result <<= 8;
            result |= (long)bytes[i] & 0xFFL;
        }
        return BoxesRunTime.boxToLong((long)result);
    }

    public LongSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$(this);
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-long", system);
    }
}

