/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.spi.BaseEnversEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.AddWorkUnit;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class EnversPostInsertEventListenerImpl
extends BaseEnversEventListener
implements PostInsertEventListener {
    public EnversPostInsertEventListenerImpl(EnversService enversService) {
        super(enversService);
    }

    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getEnversService().getEntitiesConfigurations().isVersioned(entityName)) {
            this.checkIfTransactionInProgress((SessionImplementor)event.getSession());
            AuditProcess auditProcess = this.getEnversService().getAuditProcessManager().get(event.getSession());
            AddWorkUnit workUnit = new AddWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getEnversService(), event.getId(), event.getPersister(), event.getState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, event.getState(), null, (SessionImplementor)event.getSession());
            }
        }
    }

    public boolean requiresPostCommitHandling(EntityPersister persister) {
        return this.getEnversService().getEntitiesConfigurations().isVersioned(persister.getEntityName());
    }
}

