/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.serialization.kryo.scala;

import io.altoo.serialization.kryo.scala.Transformer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)3Aa\u0002\u0005\u0001'!)Q\u0004\u0001C\u0001=!A\u0001\u0005\u0001EC\u0002\u0013%\u0011\u0005C\u0003-\u0001\u0011\u0005S\u0006C\u0003-\u0001\u0011\u0005c\u0007C\u0003F\u0001\u0011\u0005c\tC\u0003F\u0001\u0011\u0005\u0003JA\tM5RZ%/_8D_6\u0004(/Z:t_JT!!\u0003\u0006\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005-a\u0011\u0001B6ss>T!!\u0004\b\u0002\u001bM,'/[1mSj\fG/[8o\u0015\ty\u0001#A\u0003bYR|wNC\u0001\u0012\u0003\tIwn\u0001\u0001\u0014\u0007\u0001!\u0012\u0004\u0005\u0002\u0016/5\taCC\u0001\n\u0013\tAbC\u0001\u0004B]f\u0014VM\u001a\t\u00035mi\u0011\u0001C\u0005\u00039!\u00111\u0002\u0016:b]N4wN]7fe\u00061A(\u001b8jiz\"\u0012a\b\t\u00035\u0001\t!\u0002\u001c>5M\u0006\u001cGo\u001c:z+\u0005\u0011\u0003CA\u0012+\u001b\u0005!#BA\u0013'\u0003\ra'\u0010\u000e\u0006\u0003O!\nqA\u001b9pk:$(PC\u0001*\u0003\rqW\r^\u0005\u0003W\u0011\u0012!\u0002\u0014.5\r\u0006\u001cGo\u001c:z\u0003!!xNQ5oCJLHC\u0001\u00185!\r)r&M\u0005\u0003aY\u0011Q!\u0011:sCf\u0004\"!\u0006\u001a\n\u0005M2\"\u0001\u0002\"zi\u0016DQ!N\u0002A\u00029\n\u0011\"\u001b8qkR\u0014UO\u001a4\u0015\u0007]R4\b\u0005\u0002\u0016q%\u0011\u0011H\u0006\u0002\u0005+:LG\u000fC\u00036\t\u0001\u0007a\u0006C\u0003=\t\u0001\u0007Q(\u0001\u0006pkR\u0004X\u000f\u001e\"vM\u001a\u0004\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u00079LwNC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006QaM]8n\u0005&t\u0017M]=\u0015\u00059:\u0005\"B\u001b\u0006\u0001\u0004qCC\u0001\u0018J\u0011\u0015)d\u00011\u0001>\u0001")
public class LZ4KryoCompressor
implements Transformer {
    private LZ4Factory lz4factory;
    private volatile boolean bitmap$0;

    private LZ4Factory lz4factory$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.lz4factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = true;
            }
        }
        return this.lz4factory;
    }

    private LZ4Factory lz4factory() {
        if (!this.bitmap$0) {
            return this.lz4factory$lzycompute();
        }
        return this.lz4factory;
    }

    @Override
    public byte[] toBinary(byte[] inputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        int maxOutputSize = lz4.maxCompressedLength(inputSize);
        byte[] outputBuff = new byte[maxOutputSize + 4];
        int outputSize = lz4.compress(inputBuff, 0, inputSize, outputBuff, 4, maxOutputSize);
        outputBuff[0] = (byte)(inputSize & 0xFF);
        outputBuff[1] = (byte)(inputSize >> 8 & 0xFF);
        outputBuff[2] = (byte)(inputSize >> 16 & 0xFF);
        outputBuff[3] = (byte)(inputSize >> 24 & 0xFF);
        return (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(outputBuff), outputSize + 4);
    }

    @Override
    public void toBinary(byte[] inputBuff, ByteBuffer outputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        lz4.maxCompressedLength(inputSize);
        outputBuff.order(ByteOrder.LITTLE_ENDIAN).putInt(inputSize);
        lz4.compress(ByteBuffer.wrap(inputBuff), outputBuff);
    }

    @Override
    public byte[] fromBinary(byte[] inputBuff) {
        return this.fromBinary(ByteBuffer.wrap(inputBuff));
    }

    @Override
    public byte[] fromBinary(ByteBuffer inputBuff) {
        int size = inputBuff.order(ByteOrder.LITTLE_ENDIAN).getInt();
        LZ4FastDecompressor lz4 = this.lz4factory().fastDecompressor();
        byte[] outputBuff = new byte[size];
        lz4.decompress(inputBuff, ByteBuffer.wrap(outputBuff));
        return outputBuff;
    }

    public LZ4KryoCompressor() {
        Transformer.$init$(this);
    }
}

