/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class InetAddressJavaType
extends AbstractClassJavaType<InetAddress> {
    public static final InetAddressJavaType INSTANCE = new InetAddressJavaType();

    public InetAddressJavaType() {
        super(InetAddress.class);
    }

    @Override
    public String toString(InetAddress value) {
        return value == null ? null : value.toString();
    }

    @Override
    public InetAddress fromString(CharSequence string) {
        try {
            return string == null ? null : InetAddress.getByName(string.toString());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getJdbcType(3002);
    }

    @Override
    public <X> X unwrap(InetAddress value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (InetAddress.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)value.getAddress();
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.getHostAddress();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> InetAddress wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        if (value instanceof byte[]) {
            try {
                return InetAddress.getByAddress((byte[])value);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (value instanceof String) {
            try {
                return InetAddress.getByName((String)value);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 19L;
    }
}

