/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.FetchNotFoundException;
import org.hibernate.LockMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.entity.AbstractEntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntityJoinedFetchInitializer
extends AbstractEntityInitializer {
    private static final String CONCRETE_NAME = EntityJoinedFetchInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> keyAssembler;
    private final EntityValuedFetchable referencedFetchable;
    private final boolean isEnhancedForLazyLoading;
    private final NotFoundAction notFoundAction;

    public EntityJoinedFetchInitializer(EntityResultGraphNode resultDescriptor, EntityValuedFetchable referencedFetchable, NavigablePath navigablePath, LockMode lockMode, NotFoundAction notFoundAction, DomainResult<?> keyResult, Fetch identifierFetch, Fetch discriminatorFetch, AssemblerCreationState creationState) {
        super(resultDescriptor, navigablePath, lockMode, identifierFetch, discriminatorFetch, null, creationState);
        this.referencedFetchable = referencedFetchable;
        this.notFoundAction = notFoundAction;
        this.keyAssembler = keyResult == null ? null : keyResult.createResultAssembler(this, creationState);
        this.isEnhancedForLazyLoading = this.getConcreteDescriptor() != null ? this.getConcreteDescriptor().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() : false;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        Object fkKeyValue;
        if (this.shouldSkipResolveInstance(rowProcessingState)) {
            this.missing = true;
            return;
        }
        super.resolveKey(rowProcessingState);
        if (this.keyAssembler != null && (fkKeyValue = this.keyAssembler.assemble(rowProcessingState)) != null && this.isMissing()) {
            if (this.notFoundAction != NotFoundAction.IGNORE) {
                throw new FetchNotFoundException(this.referencedFetchable.getEntityMappingType().getEntityName(), fkKeyValue);
            }
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("Ignoring dangling foreign-key due to `@NotFound(IGNORE); association will be null - %s", (Object)this.getNavigablePath());
        }
    }

    @Override
    protected Object getProxy(PersistenceContext persistenceContext) {
        ModelPart referencedModelPart = this.getInitializedPart();
        if (referencedModelPart instanceof ToOneAttributeMapping) {
            boolean unwrapProxy;
            boolean bl = unwrapProxy = ((ToOneAttributeMapping)referencedModelPart).isUnwrapProxy() && this.isEnhancedForLazyLoading;
            if (unwrapProxy) {
                return null;
            }
        }
        return super.getProxy(persistenceContext);
    }

    @Override
    protected void registerLoadingEntityInstanceFromExecutionContext(RowProcessingState rowProcessingState, Object instance) {
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected boolean isEntityReturn() {
        return false;
    }

    public String toString() {
        return "EntityJoinedFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

