/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.PlatformMBeanServerLookup;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;

public class GlobalJmxConfigurationBuilder
extends GlobalJmxStatisticsConfigurationBuilder
implements Builder<GlobalJmxConfiguration> {
    private final AttributeSet attributes = GlobalJmxConfiguration.attributeDefinitionSet();

    GlobalJmxConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public GlobalJmxConfigurationBuilder withProperties(Properties properties) {
        this.attributes.attribute(GlobalJmxConfiguration.PROPERTIES).set((Object)new TypedProperties((Map)properties));
        return this;
    }

    @Override
    public GlobalJmxConfigurationBuilder addProperty(String key, String value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(GlobalJmxConfiguration.PROPERTIES).get();
        properties.put((Object)key, (Object)value);
        this.attributes.attribute(GlobalJmxConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Map)properties));
        return this;
    }

    @Override
    public GlobalJmxConfigurationBuilder domain(String domain) {
        this.attributes.attribute(GlobalJmxConfiguration.DOMAIN).set((Object)domain);
        return this;
    }

    @Override
    @Deprecated
    public GlobalJmxConfigurationBuilder cacheManagerName(String cacheManagerName) {
        this.getGlobalConfig().cacheContainer().name(cacheManagerName);
        return this;
    }

    @Override
    public GlobalJmxConfigurationBuilder mBeanServerLookup(MBeanServerLookup mBeanServerLookupInstance) {
        this.attributes.attribute(GlobalJmxConfiguration.MBEAN_SERVER_LOOKUP).set((Object)mBeanServerLookupInstance);
        return this;
    }

    @Override
    public GlobalJmxConfigurationBuilder disable() {
        this.enabled(false);
        return this;
    }

    @Override
    public GlobalJmxConfigurationBuilder enable() {
        this.enabled(true);
        return this;
    }

    @Override
    public GlobalJmxConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalJmxConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(GlobalJmxConfiguration.ENABLED).get();
    }

    public GlobalJmxConfiguration create() {
        if (this.enabled() && this.attributes.attribute(GlobalJmxConfiguration.MBEAN_SERVER_LOOKUP).isNull()) {
            this.mBeanServerLookup((MBeanServerLookup)new PlatformMBeanServerLookup());
        }
        return new GlobalJmxConfiguration(this.attributes.protect(), this.getGlobalConfig().cacheContainer().name());
    }

    public GlobalJmxConfigurationBuilder read(GlobalJmxConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "GlobalJmxConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

