/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.joda.convert.TypedFromStringConverter;
import org.joda.convert.TypedStringConverter;

final class ReflectionStringConverter<T>
implements TypedStringConverter<T> {
    private final Class<T> cls;
    private final Method toString;
    final TypedFromStringConverter<T> fromString;

    ReflectionStringConverter(Class<T> cls, Method toString, TypedFromStringConverter<T> fromString) {
        if (toString.getParameterTypes().length != 0) {
            throw new IllegalStateException("ToString method must have no parameters: " + toString);
        }
        if (toString.getReturnType() != String.class) {
            throw new IllegalStateException("ToString method must return a String: " + toString);
        }
        this.cls = cls;
        this.toString = toString;
        this.fromString = fromString;
    }

    @Override
    public String convertToString(T object) {
        try {
            return (String)this.toString.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Method is not accessible: " + this.toString);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public T convertFromString(Class<? extends T> cls, String str) {
        return this.fromString.convertFromString(cls, str);
    }

    @Override
    public Class<?> getEffectiveType() {
        return this.fromString.getEffectiveType();
    }

    public String toString() {
        return "RefectionStringConverter[" + this.cls.getSimpleName() + "]";
    }
}

