/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingInputStream;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LockInputStream
extends DecoratingInputStream {
    protected final Lock lock;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockInputStream(@Nullable @WillCloseWhenClosed InputStream in, Lock lock) {
        super(in);
        this.lock = lock;
        if (null == this.lock) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int read() throws IOException {
        this.lock.lock();
        try {
            int n = this.delegate.read();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int read(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            int n = this.delegate.read(b, off, len);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public long skip(long n) throws IOException {
        this.lock.lock();
        try {
            long l = this.delegate.skip(n);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int available() throws IOException {
        this.lock.lock();
        try {
            int n = this.delegate.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.delegate.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void mark(int readlimit) {
        this.lock.lock();
        try {
            this.delegate.mark(readlimit);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void reset() throws IOException {
        this.lock.lock();
        try {
            this.delegate.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public boolean markSupported() {
        this.lock.lock();
        try {
            boolean bl = this.delegate.markSupported();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

