/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session;

import java.time.Duration;
import java.util.Map;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveMapSessionRepository
implements ReactiveSessionRepository<MapSession> {
    private Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    private final Map<String, Session> sessions;

    public ReactiveMapSessionRepository(Map<String, Session> sessions) {
        if (sessions == null) {
            throw new IllegalArgumentException("sessions cannot be null");
        }
        this.sessions = sessions;
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    @Override
    public Mono<Void> save(MapSession session) {
        return Mono.fromRunnable(() -> {
            if (!session.getId().equals(session.getOriginalId())) {
                this.sessions.remove(session.getOriginalId());
            }
            this.sessions.put(session.getId(), new MapSession(session));
        });
    }

    @Override
    public Mono<MapSession> findById(String id) {
        return Mono.defer(() -> Mono.justOrEmpty((Object)this.sessions.get(id)).filter(session -> !session.isExpired()).map(MapSession::new).switchIfEmpty(this.deleteById(id).then(Mono.empty())));
    }

    @Override
    public Mono<Void> deleteById(String id) {
        return Mono.fromRunnable(() -> this.sessions.remove(id));
    }

    @Override
    public Mono<MapSession> createSession() {
        return Mono.defer(() -> {
            MapSession result = new MapSession();
            result.setMaxInactiveInterval(this.defaultMaxInactiveInterval);
            return Mono.just((Object)result);
        });
    }
}

