/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class MyReceiver<T>
implements Receiver,
Closeable {
    protected final List<T> list = new CopyOnWriteArrayList<T>();
    protected String name;
    protected boolean verbose;
    protected boolean raw_msgs;

    @Override
    public void receive(Message msg) {
        Message obj = this.raw_msgs ? msg : msg.getObject();
        this.list.add(obj);
        if (this.verbose) {
            System.out.println((String)(this.name() != null ? this.name() + ":" : "") + " received message from " + String.valueOf(msg.getSrc()) + ": " + String.valueOf(obj));
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        if (this.verbose) {
            System.out.printf("-- %s: view is %s\n", this.name, new_view);
        }
    }

    public MyReceiver<T> rawMsgs(boolean flag) {
        this.raw_msgs = flag;
        return this;
    }

    public List<T> list() {
        return this.list;
    }

    public List<String> list(Function<T, String> f) {
        return this.list.stream().map(f).collect(Collectors.toList());
    }

    public MyReceiver<T> verbose(boolean flag) {
        this.verbose = flag;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MyReceiver<T> name(String name) {
        this.name = name;
        return this;
    }

    public MyReceiver<T> reset() {
        this.list.clear();
        return this;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public void close() throws IOException {
        this.reset();
    }

    public String toString() {
        return String.format("%d elements", this.list.size());
    }
}

