/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install.driver;

import java.awt.Robot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.python.util.install.InstallerCommandLine;
import org.python.util.install.driver.Autotest;
import org.python.util.install.driver.DriverException;

public class GuiAutotest
extends Autotest {
    private static final int _DEFAULT_DELAY = 500;
    private Robot _robot;
    private List _keyActions = new ArrayList();
    private boolean _waiting = false;

    protected GuiAutotest(InstallerCommandLine commandLine) throws IOException, DriverException {
        super(commandLine);
        String[] args = new String[]{"-d", this.getTargetDir().getAbsolutePath()};
        this.setCommandLineArgs(args);
        this.addAdditionalArguments();
    }

    @Override
    protected String getNameSuffix() {
        return "guiTest";
    }

    protected void addKeyAction(int keyCode) {
        KeyAction keyAction = new KeyAction(keyCode);
        this.addKeyAction(keyAction);
    }

    protected void addKeyAction(int keyCode, int delay) {
        KeyAction keyAction = new KeyAction(keyCode, delay);
        this.addKeyAction(keyAction);
    }

    protected void addWaitingKeyAction(int keyCode) {
        KeyAction keyAction = new KeyAction(keyCode, true);
        this.addKeyAction(keyAction);
    }

    protected void setWaiting(boolean waiting) {
        this._waiting = waiting;
    }

    protected void execute() throws DriverException {
    }

    @Override
    public void progressFinished() {
        this.setWaiting(false);
    }

    private boolean isWaiting() {
        return this._waiting;
    }

    private void addKeyAction(KeyAction keyAction) {
        this._keyActions.add(keyAction);
    }

    private void executeKeyAction(KeyAction keyAction) {
        this._robot.delay(keyAction.getDelay());
        this._robot.keyPress(keyAction.getKeyCode());
        this._robot.delay(20);
        this._robot.keyRelease(keyAction.getKeyCode());
    }

    protected static class KeyAction {
        private int _keyCode;
        private int _delay;
        private boolean _wait;

        protected KeyAction(int keyCode) {
            this(keyCode, 500);
        }

        protected KeyAction(int keyCode, int delay) {
            this.setKeyCode(keyCode);
            this.setDelay(delay);
        }

        protected KeyAction(int keyCode, boolean wait) {
            this(keyCode, 500);
            this.setWait(wait);
        }

        protected void setKeyCode(int keyCode) {
            this._keyCode = keyCode;
        }

        protected void setDelay(int delay) {
            this._delay = delay;
        }

        protected int getDelay() {
            return this._delay;
        }

        protected int getKeyCode() {
            return this._keyCode;
        }

        protected void setWait(boolean wait) {
            this._wait = wait;
        }

        protected boolean isWait() {
            return this._wait;
        }
    }
}

