/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.FrameInstaller;
import org.python.util.install.InstallationType;

public class TypePage
extends AbstractWizardPage {
    private static final String _CUSTOM_ACTION_COMMAND = "custom";
    private JLabel _label;
    private JRadioButton _allButton;
    private JRadioButton _standardButton;
    private JRadioButton _minimumButton;
    private JRadioButton _standaloneButton;
    private JRadioButton _customButton;
    private JCheckBox _core;
    private JCheckBox _mod;
    private JCheckBox _demo;
    private JCheckBox _doc;
    private JCheckBox _src;
    private JCheckBox _ensurepip;
    private boolean _firstTime = true;

    public TypePage() {
        this.initComponents();
    }

    private void initComponents() {
        TypeChangeListener typeChangeListener = new TypeChangeListener();
        this._label = new JLabel();
        this._allButton = new JRadioButton();
        this._allButton.setActionCommand("1");
        this._allButton.addActionListener(typeChangeListener);
        this._standardButton = new JRadioButton();
        this._standardButton.setActionCommand("2");
        this._standardButton.addActionListener(typeChangeListener);
        this._minimumButton = new JRadioButton();
        this._minimumButton.setActionCommand("3");
        this._minimumButton.addActionListener(typeChangeListener);
        this._standaloneButton = new JRadioButton();
        this._standaloneButton.setActionCommand("9");
        this._standaloneButton.addActionListener(typeChangeListener);
        this._customButton = new JRadioButton();
        this._customButton.setActionCommand(_CUSTOM_ACTION_COMMAND);
        this._customButton.addActionListener(typeChangeListener);
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this._allButton);
        radioButtonGroup.add(this._standardButton);
        radioButtonGroup.add(this._minimumButton);
        radioButtonGroup.add(this._standaloneButton);
        radioButtonGroup.add(this._customButton);
        JPanel radioPanel = new JPanel(new GridLayout(0, 1));
        radioPanel.add(this._allButton);
        radioPanel.add(this._standardButton);
        radioPanel.add(this._minimumButton);
        radioPanel.add(this._standaloneButton);
        radioPanel.add(this._customButton);
        this._core = new JCheckBox();
        this._core.setEnabled(false);
        this._mod = new JCheckBox();
        this._mod.setEnabled(true);
        this._mod.setActionCommand("mod");
        this._mod.addActionListener(typeChangeListener);
        this._demo = new JCheckBox();
        this._demo.setEnabled(true);
        this._demo.setActionCommand("demo");
        this._demo.addActionListener(typeChangeListener);
        this._doc = new JCheckBox();
        this._doc.setEnabled(true);
        this._doc.setActionCommand("doc");
        this._doc.addActionListener(typeChangeListener);
        this._src = new JCheckBox();
        this._src.setEnabled(true);
        this._src.setActionCommand("src");
        this._src.addActionListener(typeChangeListener);
        this._ensurepip = new JCheckBox();
        this._ensurepip.setEnabled(true);
        this._ensurepip.setActionCommand("ensurepip");
        this._ensurepip.addActionListener(typeChangeListener);
        JPanel checkboxPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(6, 1);
        checkboxPanel.setLayout(gridLayout);
        checkboxPanel.add(this._core);
        checkboxPanel.add(this._mod);
        checkboxPanel.add(this._demo);
        checkboxPanel.add(this._doc);
        checkboxPanel.add(this._src);
        checkboxPanel.add(this._ensurepip);
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.newGridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        panel.add((Component)this._label, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        panel.add((Component)radioPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        panel.add((Component)checkboxPanel, gridBagConstraints);
        this.add(panel);
    }

    @Override
    protected String getTitle() {
        return this.getText("INSTALLATION_TYPE");
    }

    @Override
    protected String getDescription() {
        return this.getText("INSTALLATION_TYPE_DESCRIPTION");
    }

    @Override
    protected boolean isCancelVisible() {
        return true;
    }

    @Override
    protected boolean isPreviousVisible() {
        return true;
    }

    @Override
    protected boolean isNextVisible() {
        return true;
    }

    @Override
    protected JComponent getFocusField() {
        InstallationType installationType = this.getInstallationType();
        if (installationType.isAll()) {
            return this._allButton;
        }
        if (installationType.isMinimum()) {
            return this._minimumButton;
        }
        if (installationType.isStandalone()) {
            return this._standaloneButton;
        }
        if (installationType.isStandard()) {
            return this._standardButton;
        }
        return this._customButton;
    }

    @Override
    protected void activate() {
        this._label.setText(this.getText("SELECT_INSTALLATION_TYPE") + ": ");
        this._allButton.setText(this.getText("ALL"));
        this._standardButton.setText(this.getText("STANDARD"));
        this._minimumButton.setText(this.getText("MINIMUM"));
        this._standaloneButton.setText(this.getText("STANDALONE"));
        this._customButton.setText(this.getText("CUSTOM"));
        InstallationType installationType = this.getInstallationType();
        if (installationType.isAll()) {
            this._allButton.setSelected(true);
        } else if (installationType.isMinimum()) {
            this._minimumButton.setSelected(true);
        } else if (installationType.isStandalone()) {
            this._standaloneButton.setSelected(true);
        } else if (installationType.isStandard()) {
            this._standardButton.setSelected(true);
        } else {
            this._customButton.setSelected(true);
        }
        this._core.setText(this.getText("CORE"));
        this._mod.setText(this.getText("LIBRARY_MODULES"));
        this._demo.setText(this.getText("DEMOS_EXAMPLES"));
        this._doc.setText(this.getText("DOCUMENTATION"));
        this._src.setText(this.getText("SOURCES"));
        this._ensurepip.setText(this.getText("ENSUREPIP"));
        this.setCheckboxes(installationType);
    }

    @Override
    protected void passivate() {
    }

    @Override
    protected void beforeValidate() {
    }

    private InstallationType getInstallationType() {
        InstallationType installationType;
        if (this._firstTime) {
            this._firstTime = false;
            installationType = new InstallationType();
            installationType.setStandard();
            FrameInstaller.setInstallationType(installationType);
        }
        installationType = FrameInstaller.getInstallationType();
        return installationType;
    }

    void setCheckboxes(InstallationType installationType) {
        this._core.setSelected(true);
        this._mod.setSelected(installationType.installLibraryModules());
        this._demo.setSelected(installationType.installDemosAndExamples());
        this._doc.setSelected(installationType.installDocumentation());
        this._src.setSelected(installationType.installSources());
        this._ensurepip.setSelected(installationType.ensurepip());
        this._standaloneButton.setSelected(installationType.isStandalone());
        this._mod.setEnabled(!installationType.isPredefined());
        this._demo.setEnabled(!installationType.isPredefined());
        this._doc.setEnabled(!installationType.isPredefined());
        this._src.setEnabled(!installationType.isPredefined());
        this._ensurepip.setEnabled(!installationType.isPredefined());
    }

    private final class TypeChangeListener
    implements ActionListener {
        private TypeChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstallationType installationType = FrameInstaller.getInstallationType();
            String actionCommand = e.getActionCommand();
            if ("1".equals(actionCommand)) {
                installationType.setAll();
                TypePage.this.setCheckboxes(installationType);
            } else if ("2".equals(actionCommand)) {
                installationType.setStandard();
                TypePage.this.setCheckboxes(installationType);
            } else if ("3".equals(actionCommand)) {
                installationType.setMinimum();
                TypePage.this.setCheckboxes(installationType);
            } else if ("9".equals(actionCommand)) {
                installationType.setStandalone();
                TypePage.this.setCheckboxes(installationType);
            } else if (TypePage._CUSTOM_ACTION_COMMAND.equals(actionCommand)) {
                TypePage.this._mod.setEnabled(true);
                TypePage.this._demo.setEnabled(true);
                TypePage.this._doc.setEnabled(true);
                TypePage.this._src.setEnabled(true);
                TypePage.this._ensurepip.setEnabled(true);
            } else {
                boolean selected = ((JCheckBox)e.getSource()).isSelected();
                if ("mod".equals(actionCommand)) {
                    if (selected) {
                        installationType.addLibraryModules();
                    } else {
                        installationType.removeLibraryModules();
                    }
                } else if ("demo".equals(actionCommand)) {
                    if (selected) {
                        installationType.addDemosAndExamples();
                    } else {
                        installationType.removeDemosAndExamples();
                    }
                } else if ("doc".equals(actionCommand)) {
                    if (selected) {
                        installationType.addDocumentation();
                    } else {
                        installationType.removeDocumentation();
                    }
                } else if ("src".equals(actionCommand)) {
                    if (selected) {
                        installationType.addSources();
                    } else {
                        installationType.removeSources();
                    }
                } else if ("ensurepip".equals(actionCommand)) {
                    if (selected) {
                        installationType.addEnsurepip();
                    } else {
                        installationType.removeEnsurepip();
                    }
                }
            }
            FrameInstaller.setInstallationType(installationType);
        }
    }
}

