/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

public class StandalonePackager {
    private static final int BUF_SIZE = 1024;
    private File _jarFile;
    private Manifest _manifest;
    private JarOutputStream _jarOut;

    public StandalonePackager(File jarFile) {
        this._jarFile = jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, String parentDir) throws IOException {
        byte[] buffer = new byte[1024];
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(file);
            String jarEntryName = null;
            jarEntryName = parentDir != null && parentDir.length() > 0 ? parentDir + "/" + file.getName() : file.getName();
            this.getJarOutputStream().putNextEntry(new JarEntry(jarEntryName));
            int read = 0;
            while (read != -1) {
                this.getJarOutputStream().write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            this.getJarOutputStream().closeEntry();
        }
    }

    public void addFullDirectory(File directory) throws IOException {
        this.addDirectory(directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJarFile(File jarFile) throws FileNotFoundException, IOException {
        try (JarFile jarJarFile = new JarFile(jarFile);){
            this._manifest = jarJarFile.getManifest();
        }
        ZipInputStream inputStr = null;
        try {
            inputStr = new JarInputStream(new FileInputStream(jarFile));
            JarEntry entry = ((JarInputStream)inputStr).getNextJarEntry();
            while (entry != null) {
                int len;
                this.getJarOutputStream().putNextEntry(entry);
                byte[] buffer = new byte[1024];
                while ((len = inputStr.read(buffer)) > 0) {
                    this.getJarOutputStream().write(buffer, 0, len);
                }
                this.getJarOutputStream().closeEntry();
                entry = ((JarInputStream)inputStr).getNextJarEntry();
            }
        }
        finally {
            if (inputStr != null) {
                try {
                    inputStr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void close() throws FileNotFoundException, IOException {
        this.getJarOutputStream().close();
    }

    public static void emptyDirectory(File dir, File excludeFile) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(excludeFile)) continue;
            if (files[i].isDirectory()) {
                StandalonePackager.emptyDirectory(files[i], excludeFile);
                continue;
            }
            files[i].delete();
        }
        if (dir.listFiles().length == 0) {
            dir.delete();
        }
    }

    private void addDirectory(File dir, String parentDir) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        File[] filesInDir = dir.listFiles();
        for (int i = 0; i < filesInDir.length; ++i) {
            File currentFile = filesInDir[i];
            if (currentFile.isFile()) {
                if (parentDir != null && parentDir.length() > 0) {
                    this.addFile(currentFile, parentDir + "/" + dir.getName());
                    continue;
                }
                this.addFile(currentFile, dir.getName());
                continue;
            }
            String newParentDir = null;
            newParentDir = parentDir != null && parentDir.length() > 0 ? parentDir + "/" + dir.getName() : dir.getName();
            this.addDirectory(currentFile, newParentDir);
        }
    }

    private JarOutputStream getJarOutputStream() throws FileNotFoundException, IOException {
        if (this._jarOut == null) {
            this._jarOut = this._manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(this._jarFile), this._manifest) : new JarOutputStream(new FileOutputStream(this._jarFile));
        }
        return this._jarOut;
    }
}

