/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.FrameInstaller;
import org.python.util.install.JarInfo;

public class LanguagePage
extends AbstractWizardPage {
    private static Map _languageIndexes = new HashMap(2);
    private JLabel _label;
    private JComboBox _languageBox;
    private JarInfo _jarInfo;
    private boolean _activated;
    private boolean _stopListening;

    public LanguagePage(JarInfo jarInfo) {
        this._jarInfo = jarInfo;
        this._activated = false;
        this._stopListening = false;
        this.initComponents();
    }

    private void initComponents() {
        this._label = new JLabel();
        this.add(this._label);
        this._languageBox = new JComboBox();
        this._languageBox.addActionListener(new LanguageBoxListener());
        this.add(this._languageBox);
    }

    @Override
    protected String getTitle() {
        return this.getText("WELCOME_TO_JYTHON");
    }

    @Override
    protected String getDescription() {
        return this.getText("VERSION_INFO", this._jarInfo.getVersion());
    }

    @Override
    protected boolean isCancelVisible() {
        return true;
    }

    @Override
    protected boolean isPreviousVisible() {
        return false;
    }

    @Override
    protected boolean isNextVisible() {
        return true;
    }

    @Override
    protected JComponent getFocusField() {
        return this._languageBox;
    }

    @Override
    protected void activate() {
        this._label.setText(this.getText("SELECT_LANGUAGE") + ": ");
        int itemCount = this._languageBox.getItemCount();
        this._stopListening = true;
        for (int i = 0; i < itemCount; ++i) {
            this._languageBox.removeItemAt(0);
        }
        this._languageBox.addItem(this.getText("ENGLISH"));
        this._languageBox.addItem(this.getText("GERMAN"));
        this._stopListening = false;
        if (!this._activated) {
            if (Locale.getDefault().toString().startsWith(Locale.GERMAN.toString())) {
                this._languageBox.setSelectedIndex(this.getLanguageIndex(Locale.GERMAN));
                FrameInstaller.setLanguage(Locale.GERMAN);
            }
        } else {
            this._languageBox.setSelectedIndex(this.getLanguageIndex(FrameInstaller.getLanguage()));
        }
        this._activated = true;
    }

    @Override
    protected void passivate() {
    }

    @Override
    protected void beforeValidate() {
    }

    private int getLanguageIndex(Locale locale2) {
        return (Integer)_languageIndexes.get(locale2);
    }

    private Locale getLanguageFromIndex(int index) {
        Integer indexInteger = new Integer(index);
        for (Map.Entry entry : _languageIndexes.entrySet()) {
            if (!entry.getValue().equals(indexInteger)) continue;
            return (Locale)entry.getKey();
        }
        return null;
    }

    static {
        _languageIndexes.put(Locale.ENGLISH, new Integer(0));
        _languageIndexes.put(Locale.GERMAN, new Integer(1));
    }

    private class LanguageBoxListener
    implements ActionListener {
        private LanguageBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!LanguagePage.this._stopListening) {
                FrameInstaller.setLanguage(LanguagePage.this.getLanguageFromIndex(LanguagePage.this._languageBox.getSelectedIndex()));
            }
        }
    }
}

