/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.DirectoryFilter;
import org.python.util.install.FrameInstaller;
import org.python.util.install.Installation;
import org.python.util.install.JavaHomeHandler;

public class JavaSelectionPage
extends AbstractWizardPage {
    private static final long serialVersionUID = 2871052924519223110L;
    private static final String _CURRENT_ACTION_COMMAND = "current";
    private static final String _OTHER_ACTION_COMMAND = "other";
    private JRadioButton _currentButton;
    private JRadioButton _otherButton;
    private JLabel _label;
    private JTextField _javaHome;
    private JButton _browse;

    public JavaSelectionPage() {
        this.initComponents();
    }

    private void initComponents() {
        this._label = new JLabel();
        RadioButtonListener radioButtonListener = new RadioButtonListener();
        this._currentButton = new JRadioButton();
        this._currentButton.setActionCommand(_CURRENT_ACTION_COMMAND);
        this._currentButton.addActionListener(radioButtonListener);
        this._otherButton = new JRadioButton();
        this._otherButton.setActionCommand(_OTHER_ACTION_COMMAND);
        this._otherButton.addActionListener(radioButtonListener);
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this._currentButton);
        radioButtonGroup.add(this._otherButton);
        JPanel radioPanel = new JPanel(new GridLayout(0, 1));
        radioPanel.add(this._currentButton);
        radioPanel.add(this._otherButton);
        this._javaHome = new JTextField(40);
        this._javaHome.addFocusListener(new JavaFocusListener());
        this._browse = new JButton();
        this._browse.addActionListener(new BrowseButtonListener());
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.newGridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panel.add((Component)this._label, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        panel.add((Component)radioPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        panel.add((Component)this._javaHome, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        panel.add((Component)this._browse, gridBagConstraints);
        this.add(panel);
    }

    JTextField getJavaHome() {
        return this._javaHome;
    }

    @Override
    protected String getTitle() {
        return this.getText("TARGET_JAVA_HOME_PROPERTY");
    }

    @Override
    protected String getDescription() {
        return this.getText("CHOOSE_JRE");
    }

    @Override
    protected boolean isCancelVisible() {
        return true;
    }

    @Override
    protected boolean isPreviousVisible() {
        return true;
    }

    @Override
    protected boolean isNextVisible() {
        return true;
    }

    @Override
    protected JComponent getFocusField() {
        return this._currentButton;
    }

    @Override
    protected void activate() {
        this._label.setText(this.getText("SELECT_JAVA_HOME") + ": ");
        this._currentButton.setText(this.getText("CURRENT"));
        this._otherButton.setText(this.getText("OTHER"));
        this._browse.setText(this.getText("BROWSE"));
        this.setValues();
    }

    @Override
    protected void passivate() {
    }

    @Override
    protected void beforeValidate() {
    }

    private void setValues() {
        boolean current = true;
        JavaHomeHandler javaHomeHandler = FrameInstaller.getJavaHomeHandler();
        if (javaHomeHandler.isDeviation()) {
            current = false;
        }
        this.setCurrent(current);
    }

    private void setCurrent(boolean current) {
        if (current) {
            FrameInstaller.setJavaHomeHandler(new JavaHomeHandler());
            this._currentButton.setSelected(true);
            this._otherButton.setSelected(false);
            this._javaHome.setEnabled(false);
            this._browse.setEnabled(false);
        } else {
            this._currentButton.setSelected(false);
            this._otherButton.setSelected(true);
            this._javaHome.setEnabled(true);
            this._browse.setEnabled(true);
        }
        JavaHomeHandler javaHomeHandler = FrameInstaller.getJavaHomeHandler();
        if (javaHomeHandler.isValidHome()) {
            this._javaHome.setText(javaHomeHandler.getHome().getAbsolutePath());
        } else {
            this._javaHome.setText("");
        }
        this._javaHome.setToolTipText(this._javaHome.getText());
    }

    private final class RadioButtonListener
    implements ActionListener {
        private RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            JavaSelectionPage.this.setCurrent(JavaSelectionPage._CURRENT_ACTION_COMMAND.equals(actionCommand));
        }
    }

    private final class JavaFocusListener
    implements FocusListener {
        private JavaFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String javaHome = JavaSelectionPage.this._javaHome.getText();
            FrameInstaller.setJavaHomeHandler(new JavaHomeHandler(javaHome));
            JavaSelectionPage.this._javaHome.setToolTipText(javaHome);
        }
    }

    private final class BrowseButtonListener
    implements ActionListener {
        private BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnValue;
            JFileChooser fileChooser = new JFileChooser(new File(JavaSelectionPage.this._javaHome.getText()));
            fileChooser.setDialogTitle(JavaSelectionPage.this.getText("SELECT_JAVA_HOME"));
            fileChooser.setFileFilter(new DirectoryFilter());
            fileChooser.setFileSelectionMode(1);
            if (!(!fileChooser.isAcceptAllFileFilterUsed() || Installation.isMacintosh() && Installation.isJDK141())) {
                fileChooser.setAcceptAllFileFilterUsed(false);
            }
            if ((returnValue = fileChooser.showDialog(JavaSelectionPage.this._browse, JavaSelectionPage.this.getText("SELECT"))) == 0) {
                FrameInstaller.setJavaHomeHandler(new JavaHomeHandler(fileChooser.getSelectedFile().getAbsolutePath()));
                JavaSelectionPage.this.setValues();
            }
        }
    }
}

