/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.python.util.install.Installation;
import org.python.util.install.InstallerException;

public final class JavaHomeHandler {
    public static final String JAVA_HOME = "java.home";
    private static final String JAVA = "java";
    private static final String JAVA_EXE = "java.exe";
    private static final String BIN = "bin";
    private static final String DEFAULT = "_default_";
    private static final String EMPTY = "";
    private static Map<String, String> _executableNames;
    private String _currentJavaHome;

    public JavaHomeHandler() {
        this(DEFAULT);
    }

    public JavaHomeHandler(String currentJavaHome) {
        this.setCurrentJavaHome(currentJavaHome);
        this.check(this.getCurrentJavaHome());
    }

    public String getExecutableName() {
        return this.getExecutableName(this.getCurrentJavaHome());
    }

    public boolean isValidHome() {
        return !this.getFallbackExecutableName().equals(this.getExecutableName());
    }

    public File getHome() throws InstallerException {
        if (!this.isValidHome()) {
            throw new InstallerException("no valid java home");
        }
        return new File(this.getCurrentJavaHome());
    }

    public boolean isDeviation() {
        if (!JavaHomeHandler.getExecutableNames().containsKey(DEFAULT)) {
            this.check(DEFAULT);
        }
        return !this.getExecutableName(DEFAULT).equals(this.getExecutableName(this.getCurrentJavaHome()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(80);
        builder.append("[");
        if (!this.isValidHome()) {
            builder.append("in");
        }
        builder.append("valid java home: ");
        builder.append(this.getCurrentJavaHome());
        builder.append("; executable: ");
        builder.append(this.getExecutableName());
        builder.append("]");
        return builder.toString();
    }

    static void reset() {
        JavaHomeHandler.getExecutableNames().clear();
    }

    private String getExecutableName(String javaHome) {
        Map<String, String> executableNames = JavaHomeHandler.getExecutableNames();
        if (!executableNames.containsKey(javaHome)) {
            this.check(javaHome);
        }
        return executableNames.get(javaHome);
    }

    private void check(String javaHome) {
        File binDir;
        File javaHomeDir;
        boolean valid = false;
        boolean isDefault = false;
        File javaExecutableFile = null;
        if (DEFAULT.equals(javaHome)) {
            isDefault = true;
            javaHome = System.getProperty(JAVA_HOME, EMPTY);
        }
        if (javaHome.length() > 0 && (javaHomeDir = new File(javaHome)).exists() && javaHomeDir.isDirectory() && (binDir = new File(javaHomeDir, BIN)).exists() && binDir.isDirectory() && (javaExecutableFile = this.getExecutableFile(binDir)).exists()) {
            valid = true;
        }
        if (valid) {
            this.addExecutable(javaHome, javaExecutableFile);
            if (isDefault) {
                this.addExecutable(DEFAULT, javaExecutableFile);
                if (DEFAULT.equals(this.getCurrentJavaHome())) {
                    this.setCurrentJavaHome(javaHome);
                }
            }
        } else {
            this.addFallbackExecutable(javaHome);
            if (isDefault) {
                this.addFallbackExecutable(DEFAULT);
            }
        }
    }

    private String getFallbackExecutableName() {
        return JAVA;
    }

    private void addFallbackExecutable(String javaHome) {
        JavaHomeHandler.getExecutableNames().put(javaHome, this.getFallbackExecutableName());
    }

    private void addExecutable(String javaHome, File javaExecutableFile) {
        JavaHomeHandler.getExecutableNames().put(javaHome, javaExecutableFile.getAbsolutePath());
    }

    private File getExecutableFile(File binDir) {
        if (Installation.isWindows()) {
            return new File(binDir, JAVA_EXE);
        }
        return new File(binDir, JAVA);
    }

    private static Map<String, String> getExecutableNames() {
        if (_executableNames == null) {
            _executableNames = new HashMap<String, String>();
        }
        return _executableNames;
    }

    private String getCurrentJavaHome() {
        if (this._currentJavaHome == null) {
            return DEFAULT;
        }
        return this._currentJavaHome;
    }

    private void setCurrentJavaHome(String currentJavaHome) {
        this._currentJavaHome = currentJavaHome.trim();
    }
}

