/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.python.util.install.ChildProcess;

public final class FileHelper {
    private static final String EXECUTABLE_MODE = "755";

    public static boolean createTempDirectory(File tempDirectory) {
        boolean success = true;
        if (!tempDirectory.isDirectory()) {
            if (tempDirectory.exists()) {
                success = FileHelper.carryOnResult(tempDirectory.delete(), success);
            }
            if (success) {
                success = tempDirectory.mkdirs();
            }
        }
        return success;
    }

    public static boolean rmdir(File dir) {
        boolean success = true;
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    success = FileHelper.carryOnResult(file.delete(), success);
                    continue;
                }
                if (!file.isDirectory()) continue;
                success = FileHelper.carryOnResult(FileHelper.rmdir(file), success);
            }
            success = FileHelper.carryOnResult(dir.delete(), success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(File file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            int n;
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = fileReader.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            String string2 = sb.toString();
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(InputStream inputStream) throws IOException {
        try {
            int n;
            StringBuffer sb = new StringBuffer();
            byte[] b = new byte[8192];
            while ((n = inputStream.read(b)) > 0) {
                sb.append(new String(b, 0, n));
            }
            String string2 = sb.toString();
            return string2;
        }
        finally {
            inputStream.close();
        }
    }

    public static void write(File file, String contents) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write(contents);
        writer.flush();
        writer.close();
    }

    public static URL getRelativeURL(Class<?> clazz, String fileName) {
        String filePath = FileHelper.getRelativePackagePath(clazz) + "/" + fileName;
        return Thread.currentThread().getContextClassLoader().getResource(filePath);
    }

    public static InputStream getRelativeURLAsStream(Class<?> clazz, String fileName) {
        String filePath = FileHelper.getRelativePackagePath(clazz) + "/" + fileName;
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
    }

    public static void makeExecutable(File scriptFile) {
        try {
            String[] command = new String[]{"chmod", EXECUTABLE_MODE, scriptFile.getAbsolutePath()};
            long timeout = 3000L;
            ChildProcess childProcess = new ChildProcess(command, timeout);
            childProcess.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String getRelativePackagePath(Class<?> clazz) {
        String className = clazz.getName();
        String packageName = className.substring(0, className.lastIndexOf("."));
        return packageName.replace('.', '/');
    }

    private static boolean carryOnResult(boolean newResult, boolean existingResult) {
        if (existingResult) {
            return newResult;
        }
        return existingResult;
    }
}

