/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.File;
import org.python.util.install.AbstractWizardValidator;
import org.python.util.install.DirectorySelectionPage;
import org.python.util.install.FrameInstaller;
import org.python.util.install.Installation;
import org.python.util.install.ValidationException;
import org.python.util.install.ValidationInformationException;

public class DirectorySelectionPageValidator
extends AbstractWizardValidator {
    DirectorySelectionPage _page;

    DirectorySelectionPageValidator(DirectorySelectionPage page) {
        this._page = page;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validate() throws ValidationException, ValidationInformationException {
        String directory = this._page.getDirectory().getText().trim();
        if (directory == null || directory.length() <= 0) throw new ValidationException(this.getText("EMPTY_TARGET_DIRECTORY"));
        File targetDirectory = new File(directory);
        if (targetDirectory.exists()) {
            if (targetDirectory.isDirectory() && targetDirectory.list().length > 0) {
                throw new ValidationException(this.getText("NON_EMPTY_TARGET_DIRECTORY"));
            }
        } else {
            if (!targetDirectory.mkdirs()) throw new ValidationException(this.getText("UNABLE_CREATE_DIRECTORY", directory));
            throw new ValidationInformationException(Installation.getText("CREATED_DIRECTORY", directory));
        }
        FrameInstaller.setTargetDirectory(directory);
    }
}

