/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.DirectoryFilter;
import org.python.util.install.FrameInstaller;
import org.python.util.install.Installation;
import org.python.util.install.JarInfo;
import org.python.util.install.JavaHomeHandler;

public class DirectorySelectionPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -3672273150338356549L;
    private JLabel _label;
    private JTextField _directory;
    private JButton _browse;
    private JarInfo _jarInfo;

    public DirectorySelectionPage(JarInfo jarInfo) {
        this._jarInfo = jarInfo;
        this.initComponents();
    }

    private void initComponents() {
        this._label = new JLabel();
        this._directory = new JTextField(40);
        this._directory.addFocusListener(new DirectoryFocusListener());
        this._browse = new JButton();
        this._browse.addActionListener(new BrowseButtonListener());
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.newGridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panel.add((Component)this._label, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        panel.add((Component)this._directory, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        panel.add((Component)this._browse, gridBagConstraints);
        this.add(panel);
    }

    JTextField getDirectory() {
        return this._directory;
    }

    @Override
    protected String getTitle() {
        return this.getText("TARGET_DIRECTORY_PROPERTY");
    }

    @Override
    protected String getDescription() {
        return this.getText("CHOOSE_LOCATION");
    }

    @Override
    protected boolean isCancelVisible() {
        return true;
    }

    @Override
    protected boolean isPreviousVisible() {
        return true;
    }

    @Override
    protected boolean isNextVisible() {
        return true;
    }

    @Override
    protected JComponent getFocusField() {
        return this._directory;
    }

    @Override
    protected void activate() {
        this._label.setText(this.getText("SELECT_TARGET_DIRECTORY") + ": ");
        this._browse.setText(this.getText("BROWSE"));
        String directory = FrameInstaller.getTargetDirectory();
        if (directory == null || directory.length() <= 0) {
            File defaultDirectory = this.getDefaultDirectory();
            try {
                directory = defaultDirectory.getCanonicalPath();
            }
            catch (IOException e) {
                directory = "?";
            }
            FrameInstaller.setTargetDirectory(directory);
        }
        this._directory.setText(FrameInstaller.getTargetDirectory());
        this._directory.setToolTipText(this._directory.getText());
    }

    @Override
    protected void passivate() {
    }

    @Override
    protected void beforeValidate() {
    }

    private File getDefaultDirectory() {
        String directory = "";
        File defaultDirectory = null;
        if (Installation.isWindows()) {
            JavaHomeHandler handler2 = new JavaHomeHandler();
            if (handler2.isValidHome()) {
                directory = handler2.getHome().getAbsolutePath();
                if (directory.length() > 2) {
                    directory = directory.substring(0, 2);
                }
            } else {
                directory = "C:";
            }
            defaultDirectory = this.makeJythonSubDirectory(directory);
        }
        if (defaultDirectory == null && (directory = System.getProperty("user.home", "")).length() > 0) {
            defaultDirectory = this.makeJythonSubDirectory(directory);
        }
        if (defaultDirectory == null && (directory = System.getProperty("user.dir", "")).length() > 0) {
            defaultDirectory = this.makeJythonSubDirectory(directory);
        }
        if (defaultDirectory == null) {
            defaultDirectory = this.makeJythonSubDirectory(new File(new File("dummy").getAbsolutePath()).getParent());
        }
        return defaultDirectory;
    }

    private File makeJythonSubDirectory(String directory) {
        File defaultDirectory = null;
        File parentDirectory = new File(directory);
        if (parentDirectory.exists() && parentDirectory.isDirectory()) {
            String jythonSubDirectoryName = "jython" + this._jarInfo.getVersion().replaceAll("\\+", "");
            defaultDirectory = new File(parentDirectory, jythonSubDirectoryName);
        }
        return defaultDirectory;
    }

    private class DirectoryFocusListener
    implements FocusListener {
        private DirectoryFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            FrameInstaller.setTargetDirectory(DirectorySelectionPage.this._directory.getText());
            DirectorySelectionPage.this._directory.setToolTipText(DirectorySelectionPage.this._directory.getText());
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        private BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnValue;
            String directoryName = DirectorySelectionPage.this._directory.getText();
            File directory = new File(directoryName);
            if (directory.exists() && !directory.isDirectory()) {
                directory = directory.getParentFile();
            }
            JFileChooser fileChooser = new JFileChooser(directory);
            fileChooser.setDialogTitle(DirectorySelectionPage.this.getText("SELECT_TARGET_DIRECTORY"));
            fileChooser.setFileFilter(new DirectoryFilter());
            fileChooser.setFileSelectionMode(1);
            if (!(!fileChooser.isAcceptAllFileFilterUsed() || Installation.isMacintosh() && Installation.isJDK141())) {
                fileChooser.setAcceptAllFileFilterUsed(false);
            }
            if ((returnValue = fileChooser.showDialog(DirectorySelectionPage.this._browse, DirectorySelectionPage.this.getText("SELECT"))) == 0) {
                DirectorySelectionPage.this._directory.setText(fileChooser.getSelectedFile().getAbsolutePath());
                DirectorySelectionPage.this._directory.setToolTipText(DirectorySelectionPage.this._directory.getText());
                FrameInstaller.setTargetDirectory(DirectorySelectionPage.this._directory.getText());
            }
        }
    }
}

