/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.util.ArrayList;
import org.python.util.install.AbstractWizard;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.Installation;
import org.python.util.install.TextKeys;
import org.python.util.install.ValidationEvent;
import org.python.util.install.ValidationException;
import org.python.util.install.ValidationInformationException;
import org.python.util.install.ValidationListener;

public abstract class AbstractWizardValidator
implements TextKeys {
    private ArrayList _listeners;
    private AbstractWizardPage _page;
    private Thread _validatorThread;

    public final void addValidationListener(ValidationListener listener) {
        if (listener == null) {
            return;
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList(5);
        }
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    private void fireValidationFailed(ValidationException exception) {
        if (this.getWizard() != null) {
            this.getWizard().unlock();
        }
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        ValidationEvent event = new ValidationEvent(this._page);
        for (ValidationListener listener : this._listeners) {
            listener.validationFailed(event, exception);
        }
    }

    private void fireValidationInformationRequired(ValidationInformationException exception) {
        if (this.getWizard() != null) {
            this.getWizard().unlock();
        }
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        ValidationEvent event = new ValidationEvent(this._page);
        for (ValidationListener listener : this._listeners) {
            listener.validationInformationRequired(event, exception);
        }
    }

    private void fireValidationStarted() {
        if (this.getWizard() != null) {
            this.getWizard().lock();
        }
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        ValidationEvent event = new ValidationEvent(this._page);
        for (ValidationListener listener : this._listeners) {
            listener.validationStarted(event);
        }
    }

    private void fireValidationSucceeded() {
        if (this.getWizard() != null) {
            this.getWizard().unlock();
            this.getWizard().gotoNextPage();
        }
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        ValidationEvent event = new ValidationEvent(this._page);
        for (ValidationListener listener : this._listeners) {
            listener.validationSucceeded(event);
        }
    }

    protected final AbstractWizard getWizard() {
        if (this._page != null) {
            return this._page.getWizard();
        }
        return null;
    }

    protected final AbstractWizardPage getWizardPage() {
        return this._page;
    }

    public final void removeValidationListener(ValidationListener listener) {
        if (listener == null || this._listeners == null || !this._listeners.contains(listener)) {
            return;
        }
        this._listeners.remove(listener);
    }

    public final void setWizardPage(AbstractWizardPage page) {
        this._page = page;
    }

    public final void start() {
        this._validatorThread = new ValidatorThread();
        this._validatorThread.start();
    }

    protected abstract void validate() throws ValidationException, ValidationInformationException;

    final String getText(String textKey) {
        return Installation.getText(textKey);
    }

    final String getText(String textKey, String parameter0) {
        return Installation.getText(textKey, parameter0);
    }

    private class ValidatorThread
    extends Thread {
        private ValidatorThread() {
        }

        @Override
        public final void run() {
            try {
                AbstractWizardValidator.this.fireValidationStarted();
                AbstractWizardValidator.this.validate();
                AbstractWizardValidator.this.fireValidationSucceeded();
            }
            catch (ValidationException e) {
                AbstractWizardValidator.this.fireValidationFailed(e);
            }
            catch (ValidationInformationException vie) {
                AbstractWizardValidator.this.fireValidationInformationRequired(vie);
            }
        }
    }
}

