/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.util;

import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.exception.InvalidPluginVersionPropertiesException;
import com.xebialabs.plugin.manager.exception.MissingPluginVersionPropertiesException;
import com.xebialabs.plugin.manager.metadata.PluginVersionProperties;
import com.xebialabs.plugin.protocol.xlp.JarURL$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.FileSystemUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.util.Using;
import scala.util.Using$;

public final class PluginFileUtils$ {
    public static final PluginFileUtils$ MODULE$ = new PluginFileUtils$();

    public String getPluginExtension(String filename) {
        Option<String> option = ConfigWrapper$.MODULE$.getValidExtension(filename);
        if (option instanceof Some) {
            Some some = (Some)option;
            String extension = (String)some.value();
            return extension;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Filename must end with '" + ((IterableOnceOps)ConfigWrapper$.MODULE$.getExtensions().map((Function1 & Serializable)ext -> "." + ext)).mkString(" or ") + "'");
        }
        throw new MatchError(option);
    }

    public PluginVersionProperties getPluginPropertiesForZip(Path filePath) {
        return this.getPluginPropertiesForZip(filePath.toFile());
    }

    public PluginVersionProperties getPluginPropertiesForZip(String filename, byte[] bytes) {
        return (PluginVersionProperties)this.withTmpDir((Function1 & Serializable)tmpDir -> {
            File file = MODULE$.getTemporaryPluginFile((Path)tmpDir, filename, bytes);
            return MODULE$.getPluginPropertiesForZip(file);
        });
    }

    public PluginVersionProperties getPluginPropertiesForZip(File file) {
        PluginVersionProperties pluginVersionProperties;
        try {
            String filename = file.getName();
            pluginVersionProperties = (PluginVersionProperties)Using$.MODULE$.resource((Object)new ZipFile(file), (Function1 & Serializable)zipfile -> {
                Option option = Option$.MODULE$.apply((Object)zipfile.getEntry("plugin-version.properties"));
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new MissingPluginVersionPropertiesException("Could not read plugin-version.properties in " + filename);
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                ZipEntry entry = (ZipEntry)some.value();
                .colon.colon urls = new .colon.colon((Object)JarURL$.MODULE$.apply(file.getAbsolutePath(), entry.getName()), (List)Nil$.MODULE$);
                Properties props = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource((URL)urls.head()));
                Option name = Option$.MODULE$.apply((Object)props.getProperty("plugin"));
                Option version = Option$.MODULE$.apply((Object)props.getProperty("version"));
                Option pluginType = Option$.MODULE$.apply((Object)props.getProperty("type"));
                if (name.isDefined() && version.isDefined()) {
                    return new PluginVersionProperties((String)name.get(), (String)version.get(), (Option<String>)pluginType);
                }
                throw new InvalidPluginVersionPropertiesException(filename + " does not have a valid plugin-version.properties");
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ZipException e) {
            throw new IllegalStateException(e);
        }
        return pluginVersionProperties;
    }

    private <R> R withTmpDir(Function1<Path, R> block) {
        Object object;
        Path tmpDir = Files.createTempDirectory("plugin", new FileAttribute[0]);
        try {
            object = block.apply((Object)tmpDir);
        }
        finally {
            FileSystemUtils.deleteRecursively((Path)tmpDir);
        }
        return (R)object;
    }

    private File getTemporaryPluginFile(Path tmpDir, String filename, byte[] bytes) {
        Path pluginPath = tmpDir.resolve(filename);
        return Files.write(pluginPath, bytes, new OpenOption[0]).toFile();
    }

    private PluginFileUtils$() {
    }
}

