/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.CustomHeader;
import org.apache.pekko.http.scaladsl.model.headers.Date;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Server;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.User$minusAgent;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class HttpMessageRendering$ {
    public static final HttpMessageRendering$ MODULE$ = new HttpMessageRendering$();

    public void addContentHeaders(VectorBuilder<Tuple2<String, String>> headerPairs, HttpEntity entity) {
        Object object = entity.contentType() != ContentTypes$.MODULE$.NoContentType() ? headerPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-type"), (Object)entity.contentType().toString())) : BoxedUnit.UNIT;
        entity.contentLengthOption().foreach((Function1 & Serializable)x$2 -> HttpMessageRendering$.$anonfun$addContentHeaders$1(headerPairs, BoxesRunTime.unboxToLong((Object)x$2)));
    }

    public Seq<Tuple2<String, String>> renderHeaders(Seq<HttpHeader> headers2, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        VectorBuilder headerPairs = new VectorBuilder();
        this.renderHeaders(headers2, (VectorBuilder<Tuple2<String, String>>)headerPairs, (Option<Tuple2<String, String>>)None$.MODULE$, log, isServer, shouldRenderAutoHeaders, dateHeaderRendering);
        return headerPairs.result();
    }

    public void renderHeaders(Seq<HttpHeader> headersSeq, VectorBuilder<Tuple2<String, String>> headerPairs, Option<Tuple2<String, String>> peerIdHeader, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        Iterator it = headersSeq.iterator();
        boolean peerIdSeen = false;
        boolean dateSeen = false;
        while (it.hasNext()) {
            RawHeader rawHeader;
            HttpHeader header = (HttpHeader)it.next();
            if ((!header.renderInResponses() || !isServer) && (!header.renderInRequests() || isServer)) continue;
            HttpHeader httpHeader = header;
            if (httpHeader instanceof Server) {
                Server server = (Server)httpHeader;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(server, headerPairs);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (httpHeader instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)httpHeader;
                if (!isServer) {
                    HttpMessageRendering$.addHeader$1(user$minusAgent, headerPairs);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (httpHeader instanceof Date) {
                Date date = (Date)httpHeader;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(date, headerPairs);
                    dateSeen = true;
                    continue;
                }
            }
            if (httpHeader instanceof CustomHeader) {
                CustomHeader customHeader = (CustomHeader)httpHeader;
                HttpMessageRendering$.addHeader$1(customHeader, headerPairs);
                continue;
            }
            if (httpHeader instanceof RawHeader && ((rawHeader = (RawHeader)httpHeader).is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding") || rawHeader.is("date") || rawHeader.is("server") || rawHeader.is("user-agent") || rawHeader.is("connection"))) {
                HttpMessageRendering$.suppressionWarning$1(rawHeader, "illegal RawHeader", log);
                continue;
            }
            if (httpHeader instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(content$minusLength, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.", log);
                continue;
            }
            if (httpHeader instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(content$minusType, "explicit `Content-Type` header is not allowed. Set `HttpResponse.entity.contentType` instead.", log);
                continue;
            }
            if (httpHeader instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding transfer$minusEncoding = (Transfer$minusEncoding)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(transfer$minusEncoding, "`Transfer-Encoding` header is not allowed for HTTP/2", log);
                continue;
            }
            if (httpHeader instanceof Connection) {
                Connection connection = (Connection)httpHeader;
                HttpMessageRendering$.suppressionWarning$1(connection, "`Connection` header is not allowed for HTTP/2", log);
                continue;
            }
            HttpMessageRendering$.addHeader$1(httpHeader, headerPairs);
        }
        Object object = shouldRenderAutoHeaders && !dateSeen && isServer ? headerPairs.$plus$eq(dateHeaderRendering.renderHeaderPair()) : BoxedUnit.UNIT;
        if (shouldRenderAutoHeaders && !peerIdSeen) {
            Option<Tuple2<String, String>> option = peerIdHeader;
            if (option instanceof Some) {
                Some some = (Some)option;
                Tuple2 peerIdTuple = (Tuple2)some.value();
                headerPairs.$plus$eq((Object)peerIdTuple);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ VectorBuilder $anonfun$addContentHeaders$1(VectorBuilder headerPairs$1, long x$2) {
        return (VectorBuilder)headerPairs$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-length"), (Object)Long.toString(x$2)));
    }

    private static final void suppressionWarning$1(HttpHeader h, String msg, LoggingAdapter log$1) {
        log$1.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)h, (Object)msg);
    }

    private static final void addHeader$1(HttpHeader h, VectorBuilder headerPairs$2) {
        headerPairs$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.lowercaseName()), (Object)h.value()));
    }

    private HttpMessageRendering$() {
    }
}

