/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import org.python.util.install.ChildProcess;
import org.python.util.install.Installation;
import org.python.util.install.JavaHomeHandler;

public class StartScriptGenerator {
    private File _targetDirectory;

    public StartScriptGenerator(File targetDirectory, JavaHomeHandler javaHomeHandler) {
        this._targetDirectory = targetDirectory;
    }

    protected String getShebang() {
        String shebang = null;
        try {
            String[] command = new String[]{"/usr/bin/env", "python2.7", "-E", "-c", "import sys; assert sys.version_info.major == 2 and sys.version_info.minor == 7, 'Need Python 2.7, got %r' % (sys.version_info,);print sys.executable"};
            long timeout = 3000L;
            ChildProcess childProcess = new ChildProcess(command, timeout);
            childProcess.setDebug(false);
            childProcess.setSilent(true);
            int errorCode = childProcess.run();
            if (errorCode == 0) {
                shebang = "#!" + childProcess.getStdout().get(0) + " -E";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return shebang;
    }

    private final void generateLauncher(String shebang, File infile, File outfile) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(infile));
             BufferedWriter bw = new BufferedWriter(new FileWriter(outfile));){
            String line;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (i == 0) {
                    bw.write(shebang);
                } else {
                    bw.write(line);
                }
                bw.newLine();
                ++i;
            }
        }
    }

    protected final void generateStartScripts() throws IOException {
        Path bindir = this._targetDirectory.toPath().resolve("bin");
        if (Installation.isWindows()) {
            Files.delete(bindir.resolve("jython"));
            Files.delete(bindir.resolve("jython.py"));
        } else {
            String shebang = this.getShebang();
            if (shebang != null) {
                this.generateLauncher(shebang, bindir.resolve("jython.py").toFile(), bindir.resolve("jython").toFile());
            }
            Files.delete(bindir.resolve("jython.py"));
            Files.delete(bindir.resolve("jython.exe"));
            Files.setPosixFilePermissions(bindir.resolve("jython"), PosixFilePermissions.fromString("rwxr-xr-x"));
        }
    }
}

