/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.FrameInstaller;
import org.python.util.install.JarInfo;
import org.python.util.install.JarInstaller;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.ProgressListener;
import org.python.util.install.driver.Autotest;

public class ProgressPage
extends AbstractWizardPage
implements ProgressListener {
    private static final long serialVersionUID = 9013748834030994976L;
    private JarInfo _jarInfo;
    private JLabel _label;
    private JProgressBar _progressBar;
    private JLabel _progressEntry;
    private Autotest _autotest;

    public ProgressPage(JarInfo jarInfo, Autotest autotest) {
        this._jarInfo = jarInfo;
        this._autotest = autotest;
        this.initComponents();
    }

    private void initComponents() {
        JPanel northPanel = new JPanel();
        this._label = new JLabel();
        northPanel.add(this._label);
        this._progressBar = new JProgressBar();
        northPanel.add(this._progressBar);
        JPanel centerPanel = new JPanel();
        this._progressEntry = new JLabel();
        centerPanel.add(this._progressEntry);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)northPanel, "North");
        this.add((Component)centerPanel, "Center");
    }

    @Override
    protected String getTitle() {
        return this.getText("INSTALLATION_IN_PROGRESS");
    }

    @Override
    protected String getDescription() {
        return this.getText("PLEASE_WAIT");
    }

    @Override
    protected boolean isCancelVisible() {
        return true;
    }

    @Override
    protected boolean isPreviousVisible() {
        return false;
    }

    @Override
    protected boolean isNextVisible() {
        return false;
    }

    @Override
    protected JComponent getFocusField() {
        return null;
    }

    @Override
    protected void activate() {
        this._label.setText(this.getText("PROGRESS") + ": ");
        this._progressBar.setValue(0);
        this._progressBar.setStringPainted(true);
        try {
            this._progressEntry.setText(this.getText("INFLATING", this._jarInfo.getJarFile().getName()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JarInstaller jarInstaller = new JarInstaller(this, this._jarInfo);
        if (this._autotest != null) {
            jarInstaller.addInstallationListener(this._autotest);
        }
        File targetDirectory = new File(FrameInstaller.getTargetDirectory());
        JavaHomeHandler javaHomeHandler = FrameInstaller.getJavaHomeHandler();
        jarInstaller.inflate(targetDirectory, FrameInstaller.getInstallationType(), javaHomeHandler);
    }

    @Override
    protected void passivate() {
    }

    @Override
    protected void beforeValidate() {
    }

    @Override
    public void progressChanged(int newPercentage) {
        this._progressBar.setValue(newPercentage);
    }

    @Override
    public int getInterval() {
        return 1;
    }

    @Override
    public void progressFinished() {
        this._progressBar.setValue(100);
        this.getWizard().gotoNextPage();
    }

    @Override
    public void progressEntry(String entry) {
        this._progressEntry.setText(this.getText("INFLATING", entry));
    }

    @Override
    public void progressStartScripts() {
        this._progressEntry.setText(this.getText("GENERATE_START_SCRIPTS"));
    }

    @Override
    public void progressStandalone() {
        this._progressEntry.setText(this.getText("PACKING_STANDALONE_JAR"));
    }

    @Override
    public void progressEnsurepip() {
        this._progressEntry.setText(this.getText("C_ENSUREPIP"));
    }
}

