/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.FrameInstaller;
import org.python.util.install.Installation;
import org.python.util.install.InstallationType;

public class OverviewPage
extends AbstractWizardPage {
    private static final int _LONGER_LENGTH = 25;
    private static final int _SHORTER_LENGTH = 10;
    private JLabel _directoryLabel;
    private JLabel _typeLabel;
    private JTextField _directory;
    private JTextField _type;
    private JLabel _message;
    private JLabel _osLabel;
    private JCheckBox _osBox;
    private JLabel _javaLabel;
    private JTextField _javaVendor;
    private JTextField _javaVersion;
    private JCheckBox _javaBox;

    public OverviewPage() {
        this.initComponents();
    }

    private void initComponents() {
        this._directoryLabel = new JLabel();
        this._directory = new JTextField(25);
        this._directory.setEditable(false);
        this._directory.setFocusable(false);
        this._typeLabel = new JLabel();
        this._type = new JTextField(25);
        this._type.setEditable(false);
        this._type.setFocusable(false);
        this._osLabel = new JLabel();
        JTextField osName = new JTextField(25);
        osName.setText(System.getProperty("os.name"));
        osName.setToolTipText(System.getProperty("os.name"));
        osName.setEditable(false);
        osName.setFocusable(false);
        JTextField osVersion = new JTextField(10);
        osVersion.setText(System.getProperty("os.version"));
        osVersion.setToolTipText(System.getProperty("os.version"));
        osVersion.setEditable(false);
        osVersion.setFocusable(false);
        this._osBox = new JCheckBox();
        this._osBox.setEnabled(false);
        this._osBox.setSelected(Installation.isValidOs());
        this._osBox.setFocusable(false);
        this._javaLabel = new JLabel();
        this._javaLabel.setFocusable(false);
        this._javaVendor = new JTextField(25);
        this._javaVendor.setEditable(false);
        this._javaVendor.setFocusable(false);
        this._javaVersion = new JTextField(10);
        this._javaVersion.setEditable(false);
        this._javaVersion.setFocusable(false);
        this._javaBox = new JCheckBox();
        this._javaBox.setEnabled(false);
        this._javaBox.setFocusable(false);
        this._message = new JLabel();
        JPanel panel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.newGridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panel.add((Component)this._directoryLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        panel.add((Component)this._directory, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        panel.add((Component)this._typeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        panel.add((Component)this._type, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        panel.add((Component)this._osLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        panel.add((Component)osName, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        panel.add((Component)osVersion, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        panel.add((Component)this._osBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        panel.add((Component)this._javaLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        panel.add((Component)this._javaVendor, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        panel.add((Component)this._javaVersion, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        panel.add((Component)this._javaBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        panel.add((Component)this._message, gridBagConstraints);
        this.add(panel);
    }

    @Override
    protected String getTitle() {
        return this.getText("OVERVIEW_TITLE");
    }

    @Override
    protected String getDescription() {
        return this.getText("OVERVIEW_DESCRIPTION");
    }

    @Override
    protected boolean isCancelVisible() {
        return true;
    }

    @Override
    protected boolean isPreviousVisible() {
        return true;
    }

    @Override
    protected boolean isNextVisible() {
        return true;
    }

    @Override
    protected JComponent getFocusField() {
        return null;
    }

    @Override
    protected void activate() {
        String typeText;
        this._directoryLabel.setText(this.getText("TARGET_DIRECTORY_PROPERTY") + ": ");
        this._directory.setText(FrameInstaller.getTargetDirectory());
        this._directory.setToolTipText(FrameInstaller.getTargetDirectory());
        this._typeLabel.setText(this.getText("INSTALLATION_TYPE") + ": ");
        InstallationType installationType = FrameInstaller.getInstallationType();
        if (installationType.isAll()) {
            typeText = this.getText("ALL");
        } else if (installationType.isStandard()) {
            typeText = this.getText("STANDARD");
        } else if (installationType.isMinimum()) {
            typeText = this.getText("MINIMUM");
        } else if (installationType.isStandalone()) {
            typeText = this.getText("STANDALONE");
        } else {
            typeText = this.getText("CUSTOM");
            typeText = typeText + " (";
            boolean predecessor = false;
            if (installationType.installLibraryModules()) {
                if (predecessor) {
                    typeText = typeText + " ";
                }
                typeText = typeText + "mod";
                predecessor = true;
            }
            if (installationType.installDemosAndExamples()) {
                if (predecessor) {
                    typeText = typeText + " ";
                }
                typeText = typeText + "demo";
                predecessor = true;
            }
            if (installationType.installDocumentation()) {
                if (predecessor) {
                    typeText = typeText + " ";
                }
                typeText = typeText + "doc";
                predecessor = true;
            }
            if (installationType.installSources()) {
                if (predecessor) {
                    typeText = typeText + " ";
                }
                typeText = typeText + "src";
                predecessor = true;
            }
            typeText = typeText + ")";
        }
        this._type.setText(typeText);
        this._type.setToolTipText(typeText);
        this._osLabel.setText(this.getText("OS_INFO") + ": ");
        String osText = this._osBox.isSelected() ? this.getText("OK") : this.getText("MAYBE_NOT_SUPPORTED");
        this._osBox.setText(osText);
        this._javaLabel.setText(this.getText("JAVA_INFO") + ": ");
        Installation.JavaVersionInfo javaVersionInfo = FrameInstaller.getJavaVersionInfo();
        this._javaVendor.setText(javaVersionInfo.getVendor());
        this._javaVendor.setToolTipText(javaVersionInfo.getVendor());
        this._javaVersion.setText(javaVersionInfo.getVersion());
        this._javaVersion.setToolTipText(javaVersionInfo.getVersion());
        this._javaBox.setSelected(Installation.isValidJava(javaVersionInfo));
        String javaText = this._javaBox.isSelected() ? this.getText("OK") : this.getText("NOT_OK");
        this._javaBox.setText(javaText);
        this._message.setText(this.getText("CONFIRM_START", this.getText("NEXT")));
    }

    @Override
    protected void passivate() {
    }

    @Override
    protected void beforeValidate() {
    }
}

