/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChildProcess {
    private List<String> stdout;
    private List<String> stderr;
    public static final long INFINITE_TIMEOUT = -1L;
    public static final int DESTROYED_AFTER_TIMEOUT = -9898;
    private static final int NOT_SET_EXITVALUE = -9;
    private String[] _command = null;
    private Map<String, String> _environmentChanges = new HashMap<String, String>();
    private long _timeout = -1L;
    private long _pollAliveInterval = 1000L;
    Process _process;
    private int _exitValue = -9;
    private long _startTime;
    private boolean _debug = false;
    private boolean _silent = false;
    private Path _cwd;

    public ChildProcess() {
    }

    public ChildProcess(String[] command) {
        this.setCommand(command);
    }

    public ChildProcess(String[] command, long timeout) {
        this.setCommand(command);
        this.setTimeout(timeout);
    }

    public void setCommand(String[] command) {
        this._command = command;
    }

    public String[] getCommand() {
        return this._command;
    }

    public void setCWD(Path cwd) {
        this._cwd = cwd;
    }

    public void putEnvironment(String key, String value) {
        this._environmentChanges.put(key, value);
    }

    public Path getCWD() {
        return this._cwd;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setDebug(boolean debug2) {
        this._debug = debug2;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setSilent(boolean silent) {
        this._silent = silent;
    }

    public boolean isSilent() {
        return this._silent;
    }

    public void setPollAliveInterval(long pollAliveInterval) {
        this._pollAliveInterval = pollAliveInterval;
    }

    public long getPollAliveInterval() {
        return this._pollAliveInterval;
    }

    private boolean isTimeout() {
        boolean isTimeout = false;
        long currentTime = System.currentTimeMillis();
        long diff = 0L;
        long timeout = this.getTimeout();
        if (timeout != -1L && (diff = currentTime - this._startTime) > timeout) {
            isTimeout = true;
        }
        return isTimeout;
    }

    public int run() {
        block11: {
            try {
                this._startTime = System.currentTimeMillis();
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                pb.command(this.getCommand());
                if (this.getCWD() != null) {
                    pb.directory(this.getCWD().toFile());
                }
                for (Map.Entry<String, String> change : this._environmentChanges.entrySet()) {
                    if (change.getValue() == null) {
                        pb.environment().remove(change.getKey());
                        continue;
                    }
                    pb.environment().put(change.getKey(), change.getValue());
                }
                this.debugCommand(pb);
                this._process = pb.start();
                OutputMonitor stdoutMonitor = new OutputMonitor(this._process.getInputStream());
                stdoutMonitor.start();
                OutputMonitor stderrMonitor = new OutputMonitor(this._process.getErrorStream());
                stderrMonitor.start();
                while (!this.isTimeout() && this.isAlive()) {
                    try {
                        Thread.sleep(this.getPollAliveInterval());
                    }
                    catch (InterruptedException ie) {
                        if (this.isSilent()) continue;
                        ie.printStackTrace();
                    }
                }
                if (this.isAlive()) {
                    this.destroy();
                } else if (this.isDebug()) {
                    System.out.println("[ChildProcess] ended itself");
                }
                this.stdout = stdoutMonitor.getOutput();
                this.stderr = stderrMonitor.getOutput();
            }
            catch (IOException ioe) {
                if (this.isSilent()) break block11;
                ioe.printStackTrace();
            }
        }
        return this.getExitValue();
    }

    public int getExitValue() {
        return this._exitValue;
    }

    public List<String> getStdout() {
        return this.stdout;
    }

    public List<String> getStderr() {
        return this.stderr;
    }

    private void setExitValue(int exitValue) {
        this._exitValue = exitValue;
    }

    private boolean isAlive() {
        try {
            this.setExitValue(this._process.exitValue());
            return false;
        }
        catch (IllegalThreadStateException itse) {
            return true;
        }
    }

    private void destroy() {
        this._process.destroy();
        this.setExitValue(-9898);
        if (this.isDebug()) {
            System.out.println("[ChildProcess] destroying because of timeout !");
        }
    }

    private void debugCommand(ProcessBuilder pb) {
        if (this.isDebug()) {
            System.out.print("[ChildProcess] command = ");
            System.out.println(pb.command());
            System.out.print("[ChildProcess] environment = ");
            System.out.println(pb.environment());
            System.out.print("[ChildProcess] working directory = ");
            System.out.println(pb.directory());
        }
    }

    private class OutputMonitor
    extends Thread {
        private final List<String> output = new ArrayList<String>();
        private final InputStream inputStream;

        public OutputMonitor(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    this.output.add(line);
                    if (ChildProcess.this.isSilent()) continue;
                    System.out.println(line);
                }
            }
            catch (IOException ioe) {
                if (!ChildProcess.this.isSilent()) {
                    ioe.printStackTrace();
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public List<String> getOutput() {
            return this.output;
        }
    }
}

